/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.neoforge.create;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FluidFillLevelDisplaySource
extends PercentOrProgressBarDisplaySource {
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        BlockEntity blockEntity;
        if (context.sourceConfig().getInt("Mode") == 2 && (blockEntity = context.getSourceBlockEntity()) instanceof ISoftFluidTankProvider) {
            ISoftFluidTankProvider tp = (ISoftFluidTankProvider)blockEntity;
            return Component.literal((String)(tp.getSoftFluidTank().getFluidCount() + " mBtl"));
        }
        return super.provideLine(context, stats);
    }

    protected Float getProgress(DisplayLinkContext context) {
        BlockEntity te = context.getSourceBlockEntity();
        if (te instanceof ISoftFluidTankProvider) {
            ISoftFluidTankProvider tp = (ISoftFluidTankProvider)te;
            return Float.valueOf(tp.getSoftFluidTank().getHeight(1.0f));
        }
        return null;
    }

    protected boolean progressBarActive(DisplayLinkContext context) {
        return context.sourceConfig().getInt("Mode") == 1;
    }

    protected String getTranslationKey() {
        return "fluid_amount";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (!isFirstLine) {
            builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(CreateLang.translatedOptions((String)"display_source.fill_level", (String[])new String[]{"percent", "progress_bar", "fluid_amount"})).titled(CreateLang.translateDirect((String)"display_source.fill_level.display", (Object[])new Object[0])), "Mode");
        }
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

