/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.SlimedRenderTypes;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.dynamicpack.MojangNeedsToAddMoreCopper;
import net.mehvahdjukaar.supplementaries.dynamicpack.ServerDynamicResourcesGenerator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesGenerator
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesGenerator INSTANCE = new ClientDynamicResourcesGenerator();

    public ClientDynamicResourcesGenerator() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Collection<String> additionalNamespaces() {
        return List.of("minecraft");
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        super.regenerateDynamicAssets(manager);
        GlobeManager.refreshColorsAndTextures(manager);
        ColorHelper.refreshBubbleColors(manager);
        ColoredMapHandler.onResourceReload();
        SlimedRenderTypes.clear();
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            this.addEndermanHead(manager, sink);
            this.addRopeArrowModel(manager, sink);
            this.addTatteredBook(manager, sink);
            this.addGlobeItemModels(manager, sink);
            this.addSignPostAssets(manager, sink);
            this.generateBoatTextures(manager, sink);
            MojangNeedsToAddMoreCopper.run(manager, sink);
        });
    }

    private void addSignPostAssets(ResourceManager manager, ResourceSink sink) {
        Respriter respriter;
        TextureImage template;
        StaticResource spItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("way_sign_oak")));
        StaticResource spBlockModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Supplementaries.res("way_signs/way_sign_oak")));
        ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((Item)sign).getPath();
            try {
                sink.addSimilarJsonResource(manager, spItemModel, "way_sign_oak", id);
                sink.addSimilarJsonResource(manager, spBlockModel, "way_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item model for {} : {}", (Object)sign, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/way_signs/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("item/way_signs/" + Utils.getID((Item)sign).getPath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    Item signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/hanging_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                            newImage = respriter.recolor(targetPalette);
                            try (TextureImage scribbles = ClientDynamicResourcesGenerator.recolorFromVanilla(manager, vanillaSign2, Supplementaries.res("item/way_signs/sign_scribbles_mask"), Supplementaries.res("item/way_signs/scribbles_template"));){
                                newImage.applyOverlay(new TextureImage[]{scribbles});
                            }
                            catch (Exception ex) {
                                this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                            }
                        }
                        catch (Exception vanillaSign2) {
                            // empty catch block
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        sink.addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("block/way_signs/way_sign_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("block/way_signs/" + Utils.getID((Item)sign).getPath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(palette);
                        sink.addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }

    private void addGlobeItemModels(ResourceManager manager, ResourceSink sink) {
        RPUtils.appendModelOverride((ResourceManager)manager, (ResourceSink)sink, (ResourceLocation)Supplementaries.res("globe"), e -> {
            int i = 0;
            for (ResourceLocation text : GlobeManager.TEXTURES) {
                String name = text.getPath().split("/")[3].split("\\.")[0];
                e.add(new ItemOverride(Supplementaries.res("item/" + name), List.of(new ItemOverride.Predicate(Supplementaries.res("type"), (float)i))));
                ++i;
                sink.addItemModel(Supplementaries.res(name), JsonParser.parseString((String)("{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"supplementaries:item/globes/" + name + "\"    }\n}\n")));
            }
        });
    }

    private void addTatteredBook(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((ResourceManager)manager, (ResourceSink)sink, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"written_book"), e -> e.add(new ItemOverride(ResourceLocation.withDefaultNamespace((String)"item/written_book_tattered"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
            RPUtils.appendModelOverride((ResourceManager)manager, (ResourceSink)sink, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"filled_map"), e -> e.add(new ItemOverride(ResourceLocation.withDefaultNamespace((String)"item/antique_map"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
        }
    }

    private void addRopeArrowModel(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((ResourceManager)manager, (ResourceSink)sink, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"crossbow"), e -> e.add(new ItemOverride(ResourceLocation.withDefaultNamespace((String)"item/crossbow_rope_arrow"), List.of(new ItemOverride.Predicate(ResourceLocation.withDefaultNamespace((String)"charged"), 1.0f), new ItemOverride.Predicate(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
    }

    private void addEndermanHead(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue()) {
            try (TextureImage text = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/enderman/enderman"));
                 TextureImage eyeText = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/enderman/enderman_eyes"));){
                sink.addAndCloseTexture(Supplementaries.res("entity/enderman_head"), text, false);
                sink.addAndCloseTexture(Supplementaries.res("entity/enderman_head_eyes"), eyeText, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void generateBoatTextures(ResourceManager manager, ResourceSink sink) {
        TextureImage template;
        StaticResource itemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("cannon_boat_oak")));
        ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, sled) -> {
            try {
                sink.addSimilarJsonResource(manager, itemModel, "cannon_boat_oak", wood.getVariantId("cannon_boat"));
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Cannon Boat item model for {} : {}", (Object)sled, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/boat/oak"));
            try {
                Respriter respriter = Respriter.of((TextureImage)template);
                ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, sled) -> {
                    if (wood.isVanilla()) {
                        return;
                    }
                    ResourceLocation textureRes = Supplementaries.res("entity/cannon_boat/" + wood.getTexturePath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette targetPalette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(targetPalette);
                        sink.addAndCloseTexture(textureRes, newImage, false);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate sled entity texture for for {} : {}", (Object)sled, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any sled entity texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/cannon_boat/cannon_boat_oak"));
            try (TextureImage sledMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/cannon_boat/mask"));){
                Palette palette = Palette.fromImage((TextureImage)template, (TextureImage)sledMask);
                Respriter respriter = Respriter.ofPalette((TextureImage)template, (Palette)palette);
                ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, sled) -> {
                    Palette targetPalette;
                    ResourceLocation textureRes = Supplementaries.res("item/cannon_boat/" + Utils.getID((Item)sled).getPath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    Item boat = wood.getItemOfThis("boat");
                    if (boat != null) {
                        try (TextureImage vanillaBoat = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)boat));){
                            targetPalette = Palette.fromImage((TextureImage)vanillaBoat);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().warn("Could not find boat texture for wood type {}. Using plank texture : {}", wood, (Object)ex);
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Cannon Boat item texture for for {} : {}", (Object)sled, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        sink.addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Cannon Boat item texture : ", (Throwable)ex);
        }
    }

    private static void generateTagTranslations() {
        JsonObject jo = new JsonObject();
        for (Map.Entry<ResourceLocation, Resource> e : ServerDynamicResourcesGenerator.R.entrySet()) {
            ResourceLocation id = e.getKey();
            if (!id.getNamespace().equals("supplementaries")) continue;
            String path = id.getPath();
            path = path.replace("tags/", "").replace(".json", "");
            String tr = path.substring(path.lastIndexOf("/") + 1);
            jo.addProperty("supplementaries:" + path, LangBuilder.getReadableName((String)tr));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TextureImage recolorFromVanilla(ResourceManager manager, TextureImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        MojangNeedsToAddMoreCopper.runTranslations(lang);
        ModRegistry.WAY_SIGN_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.way_sign", (BlockType)type, (Item)item));
        ModRegistry.CANNON_BOAT_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.cannon_boat", (BlockType)type, (Item)item));
        String bambooSpikes = lang.getEntry("item.supplementaries.bamboo_spikes_tipped.effect");
        if (bambooSpikes == null) {
            return;
        }
        for (Potion p : BuiltInRegistries.POTION) {
            Optional<Holder> holder = Optional.of(BuiltInRegistries.POTION.wrapAsHolder((Object)p));
            String key = Potion.getName(holder, (String)"item.supplementaries.bamboo_spikes_tipped.effect.");
            String arrowName = lang.getEntry(Potion.getName(holder, (String)"item.minecraft.tipped_arrow.effect."));
            if (arrowName == null) {
                lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)Utils.getID((Potion)p).getPath())));
                continue;
            }
            lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)arrowName.toLowerCase(Locale.ROOT).replace("arrow of ", ""))));
        }
    }
}

