/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.Calendar;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.TetraCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public class MiscUtils {
    public static final Festivity FESTIVITY = Festivity.get();
    private static final Supplier<ShulkerBoxBlockEntity> SHULKER_TILE = Suppliers.memoize(() -> new ShulkerBoxBlockEntity(BlockPos.ZERO, Blocks.SHULKER_BOX.defaultBlockState()));

    public static boolean showsHints(TooltipFlag flagIn) {
        if (PlatHelper.getPhysicalSide().isServer()) {
            return false;
        }
        return ClientConfigs.General.TOOLTIP_HINTS.get();
    }

    @Nullable
    public static Entity cloneEntity(Entity entity, ServerLevel level) {
        CompoundTag c = new CompoundTag();
        entity.save(c);
        Optional opt = EntityType.create((CompoundTag)c, (Level)level);
        return opt.orElse(null);
    }

    public static boolean isSword(Item i) {
        if (i.builtInRegistryHolder().is(ModTags.STATUE_SWORDS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraSword(i)) {
            return true;
        }
        return i instanceof SwordItem;
    }

    public static boolean isTool(Item i) {
        if (i.builtInRegistryHolder().is(ModTags.STATUE_TOOLS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraTool(i)) {
            return true;
        }
        return i instanceof DiggerItem || i instanceof TridentItem;
    }

    public static boolean isAllowedInShulker(ItemStack stack, Level level) {
        ShulkerBoxBlockEntity te = SHULKER_TILE.get();
        te.setLevel(level);
        boolean first = te.canPlaceItemThroughFace(0, stack, null);
        te.setLevel(null);
        return first && stack.getItem().canFitInsideContainerItems();
    }

    public static boolean withinDistanceDown(BlockPos pos, Vec3 vector, double distW, double distDown) {
        double dx = vector.x() - ((double)pos.getX() + 0.5);
        double dy = vector.y() - ((double)pos.getY() + 0.5);
        double dz = vector.z() - ((double)pos.getZ() + 0.5);
        double myDistW = dx * dx + dz * dz;
        return myDistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static void scheduleTickOverridingExisting(ServerLevel level, BlockPos pos, Block block, int delay) {
        ScheduledTick tick = new ScheduledTick((Object)block, pos, level.getGameTime() + (long)delay, level.nextSubTickCount());
        long l = ChunkPos.asLong((BlockPos)tick.pos());
        LevelChunkTicks container = (LevelChunkTicks)level.getBlockTicks().allContainers.get(l);
        container.removeIf(t -> t.pos().equals((Object)tick.pos()) && t.type() == tick.type());
        container.schedule(tick);
    }

    public static <A, B, Buf extends ByteBuf> void writeEither(Buf buf, Either<A, B> either, BiConsumer<Buf, A> encodeA, BiConsumer<Buf, B> encodeB) {
        buf.writeBoolean(either.left().isPresent());
        if (either.left().isPresent()) {
            encodeA.accept(buf, either.left().get());
        } else {
            encodeB.accept(buf, either.right().get());
        }
    }

    public static <A, B, Buf extends ByteBuf> Either<A, B> readEither(Buf buf, Function<Buf, A> decodeA, Function<Buf, B> decodeB) {
        if (buf.readBoolean()) {
            return Either.left(decodeA.apply(buf));
        }
        return Either.right(decodeB.apply(buf));
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE,
        MY_BIRTHDAY,
        MOD_BIRTHDAY;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        public boolean isBirthday() {
            return this == MOD_BIRTHDAY || this == MY_BIRTHDAY;
        }

        public float getCandyWrappingIndex() {
            return switch (this.ordinal()) {
                case 1 -> 0.5f;
                case 3 -> 1.0f;
                default -> 0.0f;
            };
        }

        private static Festivity get() {
            if (PlatHelper.getPhysicalSide().isClient() && ClientConfigs.General.UNFUNNY.get().booleanValue()) {
                return NONE;
            }
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            int date = calendar.get(5);
            if (month == 9 && date >= 29 || month == 10 && date == 1) {
                return HALLOWEEN;
            }
            if (month == 3 && date == 1) {
                return APRILS_FOOL;
            }
            if (month == 1 && date == 14) {
                return ST_VALENTINE;
            }
            if (month == 3 && date == 22) {
                return EARTH_DAY;
            }
            if (month == 11 && date >= 20) {
                return CHRISTMAS;
            }
            if (month == 1 && date == 7) {
                return MY_BIRTHDAY;
            }
            if (month == 9 && date == 9) {
                return MOD_BIRTHDAY;
            }
            return NONE;
        }
    }
}

