/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.neoforge;

import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FlammableLiquidBlock;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class LumiseneBucketItem
extends BucketItem {
    private final int capacity;

    public LumiseneBucketItem(Supplier<? extends FiniteFluid> supplier, Item.Properties builder, int capacity) {
        super((Fluid)supplier.get(), builder);
        this.capacity = capacity;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        BlockPos blockpos2;
        VibeChecker.assertSameLevel(level, player);
        ItemStack itemstack = player.getItemInHand(usedHand);
        BlockHitResult blockhitresult = LumiseneBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos hitPos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos above = hitPos.relative(direction);
        if (!level.mayInteract(player, hitPos) || !player.mayUseItemAt(above, direction, itemstack)) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        BlockState blockstate = level.getBlockState(hitPos);
        BlockPos blockPos = blockpos2 = this.canBlockContainFluid(player, level, hitPos, blockstate) ? hitPos : above;
        if (this.emptyContents(player, level, blockpos2, blockhitresult, itemstack)) {
            this.checkExtraContent(player, level, itemstack, blockpos2);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(sp, blockpos2, itemstack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)LumiseneBucketItem.getEmptySuccessItem((ItemStack)itemstack, (Player)player), (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult hitResult, @Nullable ItemStack container) {
        BlockState newState;
        LiquidBlockContainer lc;
        LiquidBlockContainer lc2;
        BlockState stateAt = level.getBlockState(pos);
        Block blockAt = stateAt.getBlock();
        boolean canReplaceBlock = stateAt.canBeReplaced(this.content);
        boolean canFillBlock = stateAt.isAir() || canReplaceBlock || blockAt instanceof LiquidBlockContainer && (lc2 = (LiquidBlockContainer)blockAt).canPlaceLiquid(player, (BlockGetter)level, pos, stateAt, this.content);
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (!canFillBlock) {
            return hitResult != null && this.emptyContents(player, level, hitResult.getBlockPos().relative(hitResult.getDirection()), null, container);
        }
        if (containedFluidStack.isPresent() && this.content.getFluidType().isVaporizedOnPlacement(level, pos, (FluidStack)containedFluidStack.get())) {
            this.content.getFluidType().onVaporize(player, level, pos, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (blockAt instanceof LiquidBlockContainer && (lc = (LiquidBlockContainer)blockAt).canPlaceLiquid(player, (BlockGetter)level, pos, stateAt, this.content)) {
            lc.placeLiquid((LevelAccessor)level, pos, stateAt, (FluidState)this.content.defaultFluidState().setValue((Property)FiniteFluid.LEVEL, (Comparable)Integer.valueOf(this.capacity)));
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.isClientSide && canReplaceBlock && !stateAt.liquid()) {
            level.destroyBlock(pos, true);
        }
        if (!level.setBlock(pos, newState = (BlockState)this.content.defaultFluidState().createLegacyBlock().setValue((Property)FlammableLiquidBlock.MISSING_LEVELS, (Comparable)Integer.valueOf(16 - this.capacity)), 11) && !stateAt.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }
}

