/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class RopeArrowItem
extends ArrowItem {
    protected final int maxCharges;

    public RopeArrowItem(int maxCharges, Item.Properties builder) {
        super(builder);
        this.maxCharges = maxCharges;
    }

    public AbstractArrow createArrow(Level level, ItemStack itemStack, LivingEntity shooter, @Nullable ItemStack itemStack2) {
        return new RopeArrowEntity(shooter, level, itemStack.copyWithCount(1), itemStack2);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        RopeArrowEntity arrow = new RopeArrowEntity(pos.x(), pos.y(), pos.z(), level, stack.copyWithCount(1), null);
        arrow.pickup = AbstractArrow.Pickup.ALLOWED;
        return arrow;
    }

    public static int getRopes(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModComponents.CHARGES.get(), (Object)0);
    }

    public static void addRopes(ItemStack stack, int ropes) {
        stack.set(ModComponents.CHARGES.get(), (Object)Math.min(RopeArrowItem.getRopeCapacity(), RopeArrowItem.getRopes(stack) + ropes));
    }

    public static int getRopeCapacity() {
        return CommonConfigs.Tools.ROPE_ARROW_CAPACITY.get();
    }

    public static boolean isValidRope(ItemStack stack) {
        return stack.is(ModTags.ROPES);
    }

    public int getBarWidth(ItemStack stack) {
        int charges = RopeArrowItem.getRopes(stack);
        return Mth.clamp((int)Math.round((float)charges * 13.0f / (float)this.maxCharges), (int)0, (int)13);
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getBarColor(ItemStack stack) {
        return 7294006;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.rope_arrow_tooltip", (Object[])new Object[]{RopeArrowItem.getRopes(stack), this.maxCharges}));
        if (!MiscUtils.showsHints(tooltipFlag)) {
            return;
        }
        Holder.Reference<Block> override = CommonConfigs.getRopeOverride();
        if (override != null) {
            tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.rope_arrow", (Object[])new Object[]{override.key().location().toString()}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean overrideStackedOnOther(ItemStack ropeArrow, Slot pSlot, ClickAction pAction, Player pPlayer) {
        ItemStack itemstack;
        if (pAction != ClickAction.SECONDARY && RopeArrowItem.isValidRope(itemstack = pSlot.getItem())) {
            float ropes = RopeArrowItem.getRopes(ropeArrow);
            int missingRope = (int)((float)ropeArrow.getMaxDamage() - ropes);
            if (missingRope != 0) {
                ItemStack ropeTaken = pSlot.safeTake(itemstack.getCount(), missingRope, pPlayer);
                int ropeWeCanAdd = Math.min(missingRope, ropeTaken.getCount());
                RopeArrowItem.addRopes(ropeArrow, ropeWeCanAdd);
                this.playInsertSound((Entity)pPlayer);
                return true;
            }
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack ropeArrow, ItemStack ropeStack, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.allowModification(pPlayer) && RopeArrowItem.isValidRope(ropeStack)) {
            float ropes = RopeArrowItem.getRopes(ropeArrow);
            int missingRope = (int)((float)ropeArrow.getMaxDamage() - ropes);
            if (missingRope != 0) {
                int ropeWeCanAdd = Math.min(missingRope, ropeStack.getCount());
                RopeArrowItem.addRopes(ropeArrow, ropeWeCanAdd);
                ropeStack.shrink(ropeWeCanAdd);
                this.playInsertSound((Entity)pPlayer);
                return true;
            }
        }
        return false;
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.playSound(ModSounds.ROPE_PLACE.get(), 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }
}

