/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.items.components.MobContainerView;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class AbstractMobContainerItem
extends BlockItem {
    private final float mobContainerHeight;
    private final float mobContainerWidth;
    private final boolean isAquarium;

    protected AbstractMobContainerItem(Block block, Item.Properties properties, float width, float height, boolean aquarium) {
        super(block, properties);
        this.mobContainerWidth = width;
        this.mobContainerHeight = height;
        this.isAquarium = aquarium;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean isAquarium() {
        return this.isAquarium;
    }

    public float getMobContainerHeight() {
        return this.mobContainerHeight;
    }

    public float getMobContainerWidth() {
        return this.mobContainerWidth;
    }

    protected boolean canFitEntity(Entity e) {
        float margin = 0.125f;
        float h = e.getBbHeight() - margin;
        float w = e.getBbWidth() - margin;
        return w < this.mobContainerWidth && h < this.mobContainerHeight;
    }

    public void playCatchSound(Player player) {
    }

    public void playFailSound(Player player) {
    }

    public void playReleaseSound(Level world, Vec3 v) {
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.isFull(stack) ? 1 : 64;
    }

    public boolean isFull(ItemStack stack) {
        return stack.has(ModComponents.MOB_HOLDER_CONTENT.get());
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (this.isFull(stack)) {
            return false;
        }
        InteractionHand hand = player.getUsedItemHand();
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        return this.doInteract(stack, player, entity, player.getUsedItemHand()).consumesAction();
    }

    private <T extends Entity> boolean canCatch(T entity, Player player) {
        LivingEntity living;
        if (!entity.isAlive() || entity instanceof Player) {
            return false;
        }
        String name = Utils.getID((EntityType)entity.getType()).toString();
        if (CommonConfigs.Functional.CAGE_ALL_MOBS.get().booleanValue() || CapturedMobHandler.getInstance(entity.level()).isCommandMob(name)) {
            return true;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).isDeadOrDying()) {
            return false;
        }
        if (entity.getType().is(ModTags.CAPTURE_BLACKLIST)) {
            return false;
        }
        if (ForgeHelper.isMultipartEntity(entity)) {
            return false;
        }
        ICatchableMob cap = CapturedMobHandler.getInstance(entity.level()).getCatchableMobCapOrDefault(entity);
        return cap.canBeCaughtWithItem(entity, (Item)this, player);
    }

    public abstract boolean canItemCatch(Entity var1);

    public ItemStack saveEntityInItem(Entity entity, ItemStack currentStack, ItemStack bucketStack) {
        ItemStack returnStack = currentStack.copyWithCount(1);
        MobContainer mobContainer = new MobContainer(this.getMobContainerWidth(), this.getMobContainerHeight(), this.isAquarium);
        boolean success = mobContainer.captureEntity(entity, bucketStack);
        if (success) {
            returnStack.set(ModComponents.MOB_HOLDER_CONTENT.get(), (Object)MobContainerView.of(mobContainer));
            return returnStack;
        }
        return currentStack;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        MobContainerView content = (MobContainerView)stack.get(ModComponents.MOB_HOLDER_CONTENT.get());
        Player player = context.getPlayer();
        if (!context.getPlayer().isShiftKeyDown() && content != null) {
            MobContainer.MobData data = content.getDataUnsafe();
            boolean success = false;
            Level world = context.getLevel();
            Vec3 v = context.getClickLocation();
            if (data instanceof MobContainer.MobData.Bucket) {
                MobContainer.MobData.Bucket b = (MobContainer.MobData.Bucket)data;
                ItemStack bucketStack = b.getBucket();
                Item item = bucketStack.getItem();
                if (item instanceof BucketItem) {
                    BucketItem bi = (BucketItem)item;
                    bi.checkExtraContent(player, world, bucketStack.copy(), context.getClickedPos());
                    success = true;
                }
            } else if (data instanceof MobContainer.MobData.Entity) {
                MobContainer.MobData.Entity e = (MobContainer.MobData.Entity)data;
                Entity entity = EntityType.loadEntityRecursive((CompoundTag)e.getTag(), (Level)world, o -> o);
                if (entity != null) {
                    success = true;
                    if (!world.isClientSide) {
                        if (!player.isCreative() && entity instanceof NeutralMob) {
                            NeutralMob ang = (NeutralMob)entity;
                            if (!entity.getType().is(ModTags.NON_ANGERABLE)) {
                                ang.forgetCurrentTargetAndRefreshUniversalAnger();
                                ang.setPersistentAngerTarget(player.getUUID());
                                ang.setLastHurtByMob((LivingEntity)player);
                            }
                        }
                        entity.absMoveTo(v.x(), v.y(), v.z(), context.getRotation(), 0.0f);
                        if (CommonConfigs.Functional.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            mob.setPersistenceRequired();
                        }
                        UUID temp = entity.getUUID();
                        UUID dataUUID = e.getUuid();
                        if (dataUUID != null) {
                            entity.setUUID(dataUUID);
                        }
                        if (!world.addFreshEntity(entity)) {
                            entity.setUUID(temp);
                            success = world.addFreshEntity(entity);
                            if (!success) {
                                Supplementaries.LOGGER.warn("Failed to release caged mob");
                            }
                        }
                    }
                    if (player.isCreative() && e.getUuid() != null) {
                        stack.set(ModComponents.MOB_HOLDER_CONTENT.get(), (Object)content.copyWithNewUUID(Mth.createInsecureUUID((RandomSource)world.random)));
                    }
                } else {
                    Supplementaries.LOGGER.error("Failed to load entity from itemstack");
                }
            }
            if (success) {
                if (!world.isClientSide) {
                    this.playReleaseSound(world, v);
                    if (!player.hasInfiniteMaterials()) {
                        ItemStack returnItem = stack.copyWithCount(1);
                        returnItem.remove(ModComponents.MOB_HOLDER_CONTENT.get());
                        Utils.swapItemNBT((Player)player, (InteractionHand)context.getHand(), (ItemStack)stack, (ItemStack)returnItem);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return super.useOn(context);
    }

    public boolean blocksPlacement() {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        MobContainerView content = (MobContainerView)stack.get(ModComponents.MOB_HOLDER_CONTENT.get());
        if (content != null) {
            content.addToTooltip(context, tooltipComponents::add, tooltipFlag);
        }
        if (MiscUtils.showsHints(tooltipFlag)) {
            this.addPlacementTooltip(tooltipComponents);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addPlacementTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"message.supplementaries.cage.tooltip", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getTranslatedKeyMessage()}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
    }

    private void angerNearbyEntities(Entity entity, Player player) {
        if (entity instanceof NeutralMob && entity instanceof Mob) {
            AbstractMobContainerItem.getEntitiesInRange((Mob)entity).stream().filter(mob -> mob != entity).map(NeutralMob.class::cast).forEach(mob -> {
                mob.forgetCurrentTargetAndRefreshUniversalAnger();
                mob.setPersistentAngerTarget(player.getUUID());
                mob.setLastHurtByMob((LivingEntity)player);
            });
        }
        Level level = entity.level();
        if (entity instanceof Piglin) {
            entity.hurt(level.damageSources().playerAttack(player), 0.0f);
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Optional optional = villager.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
                optional.ifPresent(entities -> entities.findAll(ReputationEventHandler.class::isInstance).forEach(e -> serverLevel.onReputationEvent(ReputationEventType.VILLAGER_HURT, (Entity)player, (ReputationEventHandler)e)));
            }
        }
    }

    private static List<?> getEntitiesInRange(Mob e) {
        double d0 = e.getAttributeValue(Attributes.FOLLOW_RANGE);
        AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)e.position()).inflate(d0, 10.0, d0);
        return e.level().getEntitiesOfClass(e.getClass(), aabb, EntitySelector.NO_SPECTATORS);
    }

    public InteractionResult doInteract(ItemStack stack, Player player, Entity entity, InteractionHand hand) {
        if (hand == null) {
            return InteractionResult.PASS;
        }
        boolean canCatch = this.canCatch(entity, player);
        MutableComponent failedMessage = Component.translatable((String)"message.supplementaries.cage.fail");
        if (canCatch && entity instanceof LivingEntity) {
            int percentage;
            TamableAnimal pet;
            LivingEntity le = (LivingEntity)entity;
            if (CommonConfigs.Functional.CAGE_TAMED.get().booleanValue() && entity instanceof TamableAnimal && (!(pet = (TamableAnimal)entity).isTame() || !pet.isOwnedBy((LivingEntity)player))) {
                failedMessage = Component.translatable((String)"message.supplementaries.cage.fail_tamed");
                canCatch = false;
            }
            if ((percentage = CommonConfigs.Functional.CAGE_HEALTH_THRESHOLD.get().intValue()) != 100 && le.getHealth() > le.getMaxHealth() * ((float)percentage / 100.0f)) {
                failedMessage = Component.translatable((String)"message.supplementaries.cage.fail_health", (Object[])new Object[]{percentage + "%"});
                canCatch = false;
            }
        }
        if (canCatch) {
            ItemStack newItem;
            ItemStack bucket = ItemStack.EMPTY;
            if (this.isAquarium) {
                bucket = BucketHelper.getBucketFromEntity(entity);
            }
            if (CommonConfigs.Functional.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.setPersistenceRequired();
            }
            if ((newItem = this.saveEntityInItem(entity, stack, bucket)) == stack) {
                return InteractionResult.FAIL;
            }
            this.playCatchSound(player);
            if (player.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            Utils.swapItemNBT((Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)newItem);
            this.angerNearbyEntities(entity, player);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.dropLeash(true, !player.getAbilities().instabuild);
            }
            entity.remove(Entity.RemovalReason.DISCARDED);
            return InteractionResult.CONSUME;
        }
        if (!player.level().isClientSide && entity instanceof LivingEntity) {
            player.displayClientMessage((Component)failedMessage, true);
        }
        this.playFailSound(player);
        return InteractionResult.PASS;
    }

    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player != null && !player.isShiftKeyDown() && this.blocksPlacement()) {
            return InteractionResult.PASS;
        }
        return super.place(context);
    }
}

