/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.mixin;

import com.mojang.math.Axis;
import it.hurts.octostudios.immersiveui.ImmersiveUI;
import it.hurts.octostudios.immersiveui.client.VariableStorage;
import it.hurts.octostudios.immersiveui.system.particles.ParticleStorage;
import it.hurts.octostudios.immersiveui.system.particles.data.GenericParticleData;
import it.hurts.octostudios.immersiveui.system.particles.data.ParticleData;
import it.hurts.octostudios.immersiveui.system.particles.data.ParticleEmitter;
import it.hurts.octostudios.immersiveui.util.CommonCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin {
    @Unique
    Random random = new Random();
    @Unique
    Map<Slot, Float> expandingProgress = new HashMap<Slot, Float>();
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Shadow
    private ItemStack draggingItem;
    @Unique
    private float immersiveui$ticker;
    @Unique
    float deltaX = 0.0f;
    @Unique
    float deltaY = 0.0f;
    @Unique
    private int oX = Integer.MIN_VALUE;
    @Unique
    private int oY = Integer.MIN_VALUE;
    @Unique
    private float currentAngle = 0.0f;
    @Unique
    private float targetAngle = 0.0f;
    @Unique
    private float currentAngleVelocity = 0.0f;
    @Unique
    private float easingSpeed = ImmersiveUI.CONFIG.getFloatingItemEasingSpeed();
    @Unique
    private final float inertiaDamping = 0.75f;
    @Unique
    float timer;

    @Shadow
    protected abstract boolean isHovering(Slot var1, double var2, double var4);

    @Inject(method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderBg(Lnet/minecraft/client/gui/GuiGraphics;FII)V", shift=At.Shift.BEFORE)})
    public void renderBg(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (VariableStorage.shakeScreen) {
            VariableStorage.shakeScreen = false;
            this.timer = ImmersiveUI.CONFIG.getShakeTimer();
        }
        if (!ImmersiveUI.CONFIG.isEnableScreenShake()) {
            return;
        }
        if (this.timer > 0.0f) {
            Random rand = new Random();
            this.timer = Mth.clamp((float)(this.timer - Minecraft.getInstance().getTimer().getRealtimeDeltaTicks()), (float)0.0f, (float)ImmersiveUI.CONFIG.getShakeTimer());
            Vector2f shakeDirection = new Vector2f(rand.nextFloat(-1.0f, 1.0f), rand.nextFloat(-1.0f, 1.0f)).normalize(ImmersiveUI.CONFIG.getShakeAmplitude());
            guiGraphics.pose().translate(shakeDirection.x * (this.timer / (float)ImmersiveUI.CONFIG.getShakeTimer()), shakeDirection.y * (this.timer / (float)ImmersiveUI.CONFIG.getShakeTimer()), 0.0f);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    public void renderParticles(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        for (ParticleData data : ParticleStorage.getParticlesData()) {
            data.render(data.getPoseStackSnapshot(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true));
        }
    }

    @Inject(method={"renderFloatingItem(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderFunkyItem(GuiGraphics guiGraphics, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        float scale = ImmersiveUI.CONFIG.getHoveredItemScale();
        float deltaTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        float amplitude = ImmersiveUI.CONFIG.getFloatingItemRotationAmplitude();
        if (this.oX != Integer.MIN_VALUE && this.oY != Integer.MIN_VALUE) {
            this.targetAngle = Mth.clamp((float)(-this.deltaX / 8.0f * amplitude), (float)(-1.5707964f / (2.0f / amplitude)), (float)(1.5707964f / (2.0f / amplitude)));
            this.currentAngleVelocity += (this.targetAngle - this.currentAngle) * this.easingSpeed * deltaTime;
        }
        this.currentAngle = Mth.clamp((float)(this.currentAngle + this.currentAngleVelocity * deltaTime), (float)(-1.5707964f / (2.0f / amplitude)), (float)(1.5707964f / (2.0f / amplitude)));
        this.currentAngleVelocity *= (float)Math.pow(0.75, deltaTime);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(i + 8), (float)(j + 8), 232.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        if (ImmersiveUI.CONFIG.isEnableFloatingItemRotation()) {
            guiGraphics.pose().mulPose(Axis.ZP.rotation(Mth.abs((float)this.currentAngle) > 0.01f ? this.currentAngle : 0.0f));
        }
        guiGraphics.renderItem(itemStack, -8, -8);
        if (ImmersiveUI.CONFIG.isEnableRarityParticles()) {
            ParticleEmitter emitter;
            int color;
            List<Integer> colors = itemStack.getHoverName().getSiblings().stream().map(c -> c.getStyle().getColor() == null ? 0 : c.getStyle().getColor().getValue()).toList();
            int n = color = colors.isEmpty() ? 0xFFFFFF : colors.get(this.random.nextInt(colors.size()));
            int n2 = colors.isEmpty() ? (itemStack.getDisplayName().getStyle().getColor() != null ? itemStack.getDisplayName().getStyle().getColor().getValue() : 0xFFFFFF) : (color = color);
            if (color != 0xFFFFFF && !ParticleStorage.EMITTERS.containsKey(emitter = new ParticleEmitter(guiGraphics.pose().last().pose(), new Vector2i(-8, -8))) && (Mth.abs((float)this.deltaX) > 0.0f || Mth.abs((float)this.deltaY) > 0.0f)) {
                ParticleStorage.EMITTERS.put(emitter, new ArrayList());
                GenericParticleData particle = new GenericParticleData(-16777216 + color, 0, Mth.abs((float)this.deltaY) + Mth.abs((float)this.deltaX), 0.0f + this.random.nextFloat(-1.0f, 1.0f), 0.0f + this.random.nextFloat(-1.0f, 1.0f), this.random.nextFloat(0.8f, 1.25f), this.random.nextInt(12, 30), emitter);
                particle.direction = new Vector2f(-this.deltaX, -this.deltaY).normalize();
                ParticleStorage.addParticle(emitter, particle);
            }
        }
        Font font = Minecraft.getInstance().font;
        guiGraphics.renderItemDecorations(font, itemStack, -8, -8, string);
        guiGraphics.pose().popPose();
        ci.cancel();
    }

    @Inject(method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItem(Lnet/minecraft/world/item/ItemStack;III)V", shift=At.Shift.BEFORE)}, require=0)
    public void renderSize(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        CommonCode.floatingRenderSize(guiGraphics, slot, this.hoveredSlot, this.expandingProgress);
    }

    @Inject(method={"renderSlotHighlight(Lnet/minecraft/client/gui/GuiGraphics;III)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void disableSlotHighlight(GuiGraphics guiGraphics, int x, int y, int blitOffset, @NotNull CallbackInfo ci) {
        if (!ImmersiveUI.CONFIG.isEnableVanillaSlotHighlighting()) {
            ci.cancel();
            return;
        }
        guiGraphics.fillGradient(RenderType.gui(), x, y, x + 16, y + 16, -2130706433, -2130706433, blitOffset);
        ci.cancel();
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;isActive()Z", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void fixHovering(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci, int i, int j, int k, Slot slot) {
        if (this.isHovering(slot, mouseX, mouseY) && slot.isActive()) {
            this.hoveredSlot = slot;
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    public void resetOldMouse(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        float deltaTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        this.deltaX = (float)(this.oX - mouseX) / deltaTime / 20.0f;
        this.deltaY = (float)(this.oY - mouseY) / deltaTime / 20.0f;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    public void resetOldMouse2(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        this.oX = mouseX;
        this.oY = mouseY;
    }
}

