/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.mixin;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import com.betterchunkloading.event.EventHandler;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkPostProcessMixin
extends ChunkAccess {
    @Shadow
    @Final
    public Level level;

    public LevelChunkPostProcessMixin(ChunkPos p_187621_, UpgradeData p_187622_, LevelHeightAccessor p_187623_, Registry<Biome> p_187624_, long p_187625_, @Nullable LevelChunkSection[] p_187626_, @Nullable BlendingData p_187627_) {
        super(p_187621_, p_187622_, p_187623_, p_187624_, p_187625_, p_187626_, p_187627_);
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="HEAD")})
    private void onPost(CallbackInfo ci) {
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartPostProcessing && this.postProcessing.length != 0 && this.level.getServer() != null) {
            boolean needsSurroundingChunks = false;
            block0: for (int i = 0; i < this.postProcessing.length; ++i) {
                if (this.postProcessing[i] == null) continue;
                for (Short oshort : this.postProcessing[i]) {
                    BlockPos blockpos = ProtoChunk.unpackOffsetCoordinates((short)oshort, (int)this.getSectionYFromSectionIndex(i), (ChunkPos)this.chunkPos);
                    BlockState blockstate = this.getBlockState(blockpos);
                    FluidState fluidstate = blockstate.getFluidState();
                    if (!fluidstate.isEmpty()) {
                        needsSurroundingChunks = true;
                        break block0;
                    }
                    if (blockstate.getBlock() instanceof LiquidBlock || blockpos.getX() + 1 >> 4 == this.chunkPos.x && blockpos.getX() - 1 >> 4 == this.chunkPos.x && blockpos.getZ() + 1 >> 4 == this.chunkPos.z && blockpos.getX() - 1 >> 4 == this.chunkPos.z) continue;
                    needsSurroundingChunks = true;
                    break block0;
                }
            }
            if (!needsSurroundingChunks) {
                return;
            }
            for (ShortList shorts : this.postProcessing) {
                if (shorts == null || shorts.isEmpty()) continue;
                ((ServerChunkCache)this.level.getChunkSource()).distanceManager.addTicket(BetterChunkLoading.TICKET_POST_PROCESS, this.chunkPos, ChunkLevel.byStatus((FullChunkStatus)FullChunkStatus.FULL) - 1, (Object)this.chunkPos);
                EventHandler.ChunkInfo info = new EventHandler.ChunkInfo(this.level.getServer().getTickCount(), this.chunkPos, this.level, Arrays.copyOf(this.postProcessing, this.postProcessing.length));
                EventHandler.addChunkToQueue(info);
                Arrays.fill(this.postProcessing, null);
                break;
            }
        }
    }
}

