/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.entity;

import java.util.Locale;
import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.block.entity.MarketBlockEntity;
import net.blay09.mods.farmingforblockheads.entity.MerchantGoal;
import net.blay09.mods.farmingforblockheads.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MerchantEntity
extends PathfinderMob {
    private static final Random rand = new Random();
    private BlockPos marketPos;
    private Direction facing;
    private boolean spawnAnimationStarted;
    private boolean spawnDone;
    private SpawnAnimationType spawnAnimation = SpawnAnimationType.MAGIC;
    private BlockPos marketEntityPos;
    private int diggingAnimation;
    private BlockState diggingBlockState;
    private ResourceLocation textureLocation;

    public MerchantEntity(EntityType<MerchantEntity> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 0.6, 0.6));
        this.goalSelector.addGoal(5, (Goal)new MerchantGoal(this, 0.6));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        MarketBlockEntity market = this.getMarketTileEntity();
        if (market != null) {
            Balm.getNetworking().openGui(player, (MenuProvider)market);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.marketPos != null) {
            compound.putLong("MarketPos", this.marketPos.asLong());
        }
        if (this.facing != null) {
            compound.putByte("Facing", (byte)this.facing.get3DDataValue());
        }
        compound.putBoolean("SpawnDone", this.spawnDone);
        compound.putByte("SpawnAnimation", (byte)this.spawnAnimation.ordinal());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (!this.hasCustomName()) {
            String merchantName = FarmingForBlockheadsConfig.getActive().getRandomMerchantName(rand);
            this.setCustomName((Component)Component.literal((String)merchantName));
        }
        if (compound.contains("MarketPos")) {
            this.setMarket(BlockPos.of((long)compound.getLong("MarketPos")), Direction.from3DDataValue((int)compound.getByte("Facing")));
        }
        this.spawnDone = compound.getBoolean("SpawnDone");
        this.spawnAnimation = SpawnAnimationType.values()[compound.getByte("SpawnAnimation")];
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.VILLAGER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (!level.isClientSide && this.tickCount % 20 == 0 && !this.isMarketValid()) {
            level.broadcastEntityEvent((Entity)this, (byte)12);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (!this.spawnDone && !this.spawnAnimationStarted) {
            this.spawnAnimationStarted = true;
            switch (this.spawnAnimation.ordinal()) {
                case 2: {
                    level.broadcastEntityEvent((Entity)this, (byte)13);
                    break;
                }
                case 1: {
                    level.broadcastEntityEvent((Entity)this, (byte)14);
                    break;
                }
                case 0: {
                    level.broadcastEntityEvent((Entity)this, (byte)15);
                }
            }
        }
        if (this.diggingAnimation > 0) {
            --this.diggingAnimation;
            double posX = this.getX();
            double posY = this.getY();
            double posZ = this.getZ();
            for (int i = 0; i < 4; ++i) {
                BlockState diggingState = this.diggingBlockState != null ? this.diggingBlockState : Blocks.DIRT.defaultBlockState();
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, diggingState), posX, posY, posZ, Math.random() * 2.0 - 1.0, Math.random() * 4.0, Math.random() * 2.0 - 1.0);
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, diggingState), posX, posY, posZ, (Math.random() - 0.5) * 0.5, Math.random() * 0.5, (Math.random() - 0.5) * 0.5);
            }
            if (this.diggingAnimation % 2 == 0) {
                level.playLocalSound(posX, posY, posZ, SoundType.GRAVEL.getHitSound(), SoundSource.BLOCKS, 0.2f, (float)(Math.random() + 0.5), false);
            }
        }
    }

    public void handleEntityEvent(byte id) {
        Level level = this.level();
        if (id == 12) {
            this.disappear();
        } else if (id == 13) {
            this.diggingBlockState = level.getBlockState(this.blockPosition().below());
            this.diggingAnimation = 60;
        } else if (id == 14) {
            BlockPos pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, this.blockPosition());
            level.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.falling.get(), SoundSource.NEUTRAL, 0.2f, 1.0f, false);
        } else if (id == 15) {
            double posX = this.getX();
            double posY = this.getY();
            double posZ = this.getZ();
            level.playLocalSound(posX + 0.5, posY + 1.0, posZ + 0.5, SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.2f, 1.0f, false);
            for (int i = 0; i < 50; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, posX + 0.5, posY + 1.0, posZ + 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            }
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, posX + 0.5, posY + 1.0, posZ + 0.5, 0.0, 0.0, 0.0);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        if (!this.spawnDone && damageSource == this.level().damageSources().fall()) {
            double posX = this.getX();
            double posY = this.getY();
            double posZ = this.getZ();
            this.level().playLocalSound(posX, posY, posZ, this.getHurtSound(damageSource), SoundSource.NEUTRAL, 1.0f, 2.0f, false);
            this.spawnDone = true;
            return;
        }
        super.actuallyHurt(damageSource, damageAmount);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (Math.random() < 0.001) {
            this.setCustomName((Component)Component.literal((String)(Math.random() <= 0.5 ? "Pam" : "Blay")));
        } else {
            String merchantName = FarmingForBlockheadsConfig.getActive().getRandomMerchantName(rand);
            this.setCustomName((Component)Component.literal((String)merchantName));
        }
        return super.finalizeSpawn(level, difficulty, mobSpawnType, spawnGroupData);
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isBaby() {
        return FarmingForBlockheadsConfig.getActive().treatMerchantsLikeBabies;
    }

    public void setMarket(BlockPos marketPos, Direction facing) {
        this.marketPos = marketPos;
        this.marketEntityPos = marketPos.relative(facing.getOpposite());
        this.facing = facing;
    }

    @Nullable
    public BlockPos getMarketEntityPosition() {
        return this.marketEntityPos;
    }

    public boolean isAtMarket() {
        return this.marketEntityPos != null && this.distanceToSqr(Vec3.atCenterOf((Vec3i)this.marketEntityPos.relative(this.facing.getOpposite()))) <= 1.0;
    }

    @Nullable
    private MarketBlockEntity getMarketTileEntity() {
        if (this.marketPos == null) {
            return null;
        }
        BlockEntity tileEntity = this.level().getBlockEntity(this.marketPos);
        if (tileEntity instanceof MarketBlockEntity) {
            MarketBlockEntity market = (MarketBlockEntity)tileEntity;
            return market;
        }
        return null;
    }

    private boolean isMarketValid() {
        return this.marketPos != null && this.level().getBlockState(this.marketPos).getBlock() == ModBlocks.market;
    }

    public void setToFacingAngle() {
        float facingAngle = this.facing.toYRot();
        this.setRot(facingAngle, 0.0f);
        this.setYHeadRot(facingAngle);
        this.setYBodyRot(facingAngle);
    }

    private void disappear() {
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        Level level = this.level();
        level.playLocalSound(posX, posY, posZ, SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        for (int i = 0; i < 50; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, posX, posY + 1.0, posZ, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
        }
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, posX, posY + 1.0, posZ, 0.0, 0.0, 0.0);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void setSpawnAnimation(SpawnAnimationType spawnAnimation) {
        this.spawnAnimation = spawnAnimation;
    }

    public int getDiggingAnimation() {
        return this.diggingAnimation;
    }

    public void setCustomName(@Nullable Component component) {
        super.setCustomName(component);
        this.textureLocation = null;
    }

    @Nullable
    public ResourceLocation getTextureLocation() {
        Component customName = this.getCustomName();
        if (this.textureLocation == null && customName != null) {
            String normalizedName = customName.getString();
            normalizedName = normalizedName.replaceAll("[^A-Za-z0-9]", "_");
            normalizedName = normalizedName.toLowerCase(Locale.ENGLISH);
            this.textureLocation = ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)("textures/entity/merchant_" + normalizedName + ".png"));
        } else if (this.textureLocation != null && customName == null) {
            this.textureLocation = null;
        }
        return this.textureLocation;
    }

    public static enum SpawnAnimationType {
        MAGIC,
        FALLING,
        DIGGING;

    }
}

