/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelRenderer;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlockEntity;
import java.util.Map;
import java.util.function.Supplier;
import net.liukrast.eg.api.event.AbstractPanelRenderEvent;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={FactoryPanelRenderer.class})
public class FactoryPanelRendererMixin {
    @ModifyExpressionValue(method={"renderSafe(Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;getAmount()I")})
    private int renderSafe(int original, @Local FactoryPanelBehaviour behaviour, @Local(argsOnly=true) float partialTicks, @Local(argsOnly=true) PoseStack ms, @Local(argsOnly=true) MultiBufferSource buffer, @Local(argsOnly=true, ordinal=0) int light, @Local(argsOnly=true, ordinal=1) int overlay) {
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour abstractPanel = (AbstractPanelBehaviour)behaviour;
            ms.pushPose();
            NeoForge.EVENT_BUS.post((Event)new AbstractPanelRenderEvent(abstractPanel, partialTicks, ms, buffer, light, overlay));
            ms.popPose();
            return abstractPanel.shouldRenderBulb() ? 1 : 0;
        }
        return original;
    }

    @ModifyArg(method={"renderPath"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/render/SuperByteBuffer;color(I)Lnet/createmod/catnip/render/SuperByteBuffer;"))
    private static int renderPath(int color, @Local(argsOnly=true) FactoryPanelBehaviour behaviour, @Local(argsOnly=true) FactoryPanelConnection connection, @Local(ordinal=0) boolean displayLinkMode, @Local(ordinal=1) boolean redstoneLinkMode) {
        if (displayLinkMode || redstoneLinkMode) {
            return color;
        }
        FactoryPanelBehaviour other = FactoryPanelBehaviour.at((BlockAndTintGetter)behaviour.getWorld(), (FactoryPanelConnection)connection);
        if (other == null) {
            return color;
        }
        if (!(other instanceof AbstractPanelBehaviour) && !(behaviour instanceof AbstractPanelBehaviour)) {
            return color;
        }
        Map<PanelConnection<?>, Supplier<?>> connectionsA = PanelConnections.getConnections(behaviour);
        Map<PanelConnection<?>, Supplier<?>> connectionsB = PanelConnections.getConnections(other);
        for (PanelConnection<?> panelConnection : connectionsA.keySet()) {
            if (!connectionsB.containsKey(panelConnection)) continue;
            if (panelConnection == PanelConnections.FILTER) {
                return color;
            }
            return panelConnection.getColorGeneric(connectionsA.get(panelConnection), connectionsB.get(panelConnection));
        }
        return color;
    }

    @ModifyExpressionValue(method={"renderPath"}, at={@At(value="MIXINEXTRAS:EXPRESSION", ordinal=0)})
    @Definitions(value={@Definition(id="behaviour", local={@Local(type=FactoryPanelBehaviour.class, argsOnly=true)}), @Definition(id="count", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;count:I"})})
    @Expression(value={"behaviour.count == 0"})
    private static boolean renderPath(boolean original, @Local(argsOnly=true) FactoryPanelBehaviour behaviour) {
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour ab = (AbstractPanelBehaviour)behaviour;
            if (ab.hasConnection(PanelConnections.FILTER)) {
                if (ab.hasConnection(PanelConnections.REDSTONE)) {
                    return !ab.shouldUseRedstoneInsteadOfFilter() && original;
                }
                return original;
            }
            return !ab.hasConnection(PanelConnections.REDSTONE);
        }
        return original;
    }

    @ModifyExpressionValue(method={"renderPath"}, at={@At(value="MIXINEXTRAS:EXPRESSION", ordinal=0)})
    @Definitions(value={@Definition(id="behaviour", local={@Local(type=FactoryPanelBehaviour.class, argsOnly=true)}), @Definition(id="satisfied", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;satisfied:Z"})})
    @Expression(value={"behaviour.satisfied"})
    private static boolean renderPath$1(boolean original, @Local(argsOnly=true) FactoryPanelBehaviour behaviour) {
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour ab = (AbstractPanelBehaviour)behaviour;
            return ab.getConnectionValue(PanelConnections.REDSTONE).orElse(0) > 0;
        }
        return original;
    }

    @ModifyExpressionValue(method={"renderPath"}, at={@At(value="MIXINEXTRAS:EXPRESSION", ordinal=0)})
    @Definitions(value={@Definition(id="behaviour", local={@Local(type=FactoryPanelBehaviour.class, argsOnly=true)}), @Definition(id="redstonePowered", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;redstonePowered:Z"})})
    @Expression(value={"behaviour.redstonePowered"})
    private static boolean renderPath$2(boolean original, @Local(argsOnly=true) FactoryPanelBehaviour behaviour, @Local FactoryPanelSupportBehaviour sbe) {
        AbstractPanelBehaviour ab;
        if (behaviour instanceof AbstractPanelBehaviour && (ab = (AbstractPanelBehaviour)behaviour).hasConnection(PanelConnections.REDSTONE)) {
            return ((RedstoneLinkBlockEntity)sbe.blockEntity).getReceivedSignal() > 0;
        }
        return original;
    }
}

