/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FactoryPanelBlock.class})
public abstract class FactoryPanelBlockMixin
extends Block {
    @Unique
    private static ItemStack extra_gauges$stored$itemStack;

    public FactoryPanelBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)blockEntity;
            Vec3 location = target.getLocation();
            FactoryPanelBlock.PanelSlot slot = FactoryPanelBlockMixin.getTargetedSlot(pos, state, location);
            Object v = be.panels.get(slot);
            if (v instanceof AbstractPanelBehaviour) {
                AbstractPanelBehaviour ab = (AbstractPanelBehaviour)((Object)v);
                if (ab.active) {
                    return ab.getItem().getDefaultInstance();
                }
            }
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder params) {
        return new ArrayList<ItemStack>();
    }

    @Shadow
    public static FactoryPanelBlock.PanelSlot getTargetedSlot(BlockPos pos, BlockState blockState, Vec3 clickLocation) {
        throw new AssertionError((Object)"Mixin injection failed");
    }

    @ModifyExpressionValue(method={"getStateForPlacement"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isClientSide()Z")})
    private boolean getStateForPlacement(boolean original, @Local(argsOnly=true) BlockPlaceContext context, @Local FactoryPanelBlockEntity blockEntity, @Local(ordinal=1) BlockState state, @Local Vec3 location) {
        if (original) {
            return true;
        }
        Item item = context.getItemInHand().getItem();
        if (!(item instanceof PanelBlockItem)) {
            return false;
        }
        PanelBlockItem panelBlockItem = (PanelBlockItem)item;
        panelBlockItem.applyExtraPlacementData(context, blockEntity, FactoryPanelBlockMixin.getTargetedSlot(context.getClickedPos(), state, location));
        return true;
    }

    @ModifyArg(method={"lambda$onSneakWrenched$0"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;placeItemBackInInventory(Lnet/minecraft/world/item/ItemStack;)V"))
    private static ItemStack asStack(ItemStack original, @Local FactoryPanelBehaviour behaviour) {
        if (!(behaviour instanceof AbstractPanelBehaviour)) {
            return original;
        }
        AbstractPanelBehaviour abstractPanelBehaviour = (AbstractPanelBehaviour)behaviour;
        return abstractPanelBehaviour.getItem().getDefaultInstance();
    }

    @WrapWithCondition(method={"setPlacedBy"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlock;withBlockEntityDo(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Ljava/util/function/Consumer;)V")})
    private boolean withBlockEntityDo(FactoryPanelBlock instance, BlockGetter blockGetter, BlockPos pos, Consumer<FactoryPanelBlockEntity> consumer, @Local(argsOnly=true) ItemStack stack, @Local FactoryPanelBlock.PanelSlot initialSlot) {
        Item item = stack.getItem();
        if (!(item instanceof PanelBlockItem)) {
            return true;
        }
        PanelBlockItem panelBlockItem = (PanelBlockItem)item;
        ((FactoryPanelBlock)FactoryPanelBlock.class.cast((Object)this)).withBlockEntityDo(blockGetter, pos, blockEntity -> panelBlockItem.applyToSlot((FactoryPanelBlockEntity)blockEntity, initialSlot));
        return false;
    }

    @Inject(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/BlockHitResult;getLocation()Lnet/minecraft/world/phys/Vec3;")}, cancellable=true)
    private void useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<ItemInteractionResult> cir) {
        Component error;
        Item item = stack.getItem();
        if (!(item instanceof PanelBlockItem)) {
            return;
        }
        PanelBlockItem panelBlockItem = (PanelBlockItem)item;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity panel = (FactoryPanelBlockEntity)blockEntity;
            if (panel.restocker) {
                AllSoundEvents.DENY.playOnServer(level, (Vec3i)pos);
                player.displayClientMessage((Component)CreateLang.translate((String)"factory_panel.custom_panel_on_restocker", (Object[])new Object[0]).component(), true);
                cir.setReturnValue((Object)ItemInteractionResult.FAIL);
                return;
            }
        }
        if ((error = panelBlockItem.isReadyForPlacement(stack, level, pos, player)) != null) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)pos);
            player.displayClientMessage(error, true);
            cir.setReturnValue((Object)ItemInteractionResult.FAIL);
        }
    }

    @ModifyExpressionValue(method={"useItemOn"}, at={@At(value="INVOKE", target="Lcom/tterrag/registrate/util/entry/BlockEntry;isIn(Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean useItemOn(boolean original, @Local(argsOnly=true) ItemStack stack) {
        return original || stack.getItem() instanceof PanelBlockItem;
    }

    @ModifyExpressionValue(method={"useItemOn"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlockItem;isTuned(Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean useItemOn$$1(boolean original, @Local(argsOnly=true) ItemStack stack) {
        return original || stack.getItem() instanceof PanelBlockItem;
    }

    @ModifyExpressionValue(method={"lambda$useItemOn$2"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlockEntity;addPanel(Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlock$PanelSlot;Ljava/util/UUID;)Z")})
    private boolean lambda$useItemOn$2(boolean original, @Local(argsOnly=true) ItemStack stack, @Local(argsOnly=true) FactoryPanelBlockEntity blockEntity, @Local(argsOnly=true) FactoryPanelBlock.PanelSlot newSlot) {
        PanelBlockItem blockItem;
        Item item;
        return original || (item = stack.getItem()) instanceof PanelBlockItem && (blockItem = (PanelBlockItem)item).applyToSlot(blockEntity, newSlot);
    }

    @WrapWithCondition(method={"lambda$useItemOn$2"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;displayClientMessage(Lnet/minecraft/network/chat/Component;Z)V")})
    private boolean lambda$useItemOn$2(Player instance, Component chatComponent, boolean actionBar, @Local(argsOnly=true) ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof PanelBlockItem)) {
            return true;
        }
        PanelBlockItem blockItem = (PanelBlockItem)item;
        return blockItem.getPlacedMessage() == null;
    }

    @ModifyArg(method={"lambda$useItemOn$2"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;displayClientMessage(Lnet/minecraft/network/chat/Component;Z)V"))
    private Component lambda$useItemOn$2(Component message, @Local(argsOnly=true) ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof PanelBlockItem)) {
            return message;
        }
        PanelBlockItem blockItem = (PanelBlockItem)item;
        return blockItem.getPlacedMessage();
    }

    @Inject(method={"lambda$tryDestroySubPanelFirst$3"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlockEntity;activePanels()I")})
    private static void lambda$tryDestroySubPanelFirst$3(FactoryPanelBlock.PanelSlot destroyedSlot, Player player, Level level, BlockPos pos, FactoryPanelBlockEntity fpbe, CallbackInfoReturnable<InteractionResult> cir) {
        FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)fpbe.panels.get(destroyedSlot);
        if (!(behaviour instanceof AbstractPanelBehaviour)) {
            extra_gauges$stored$itemStack = null;
        } else {
            AbstractPanelBehaviour panelBehaviour = (AbstractPanelBehaviour)behaviour;
            extra_gauges$stored$itemStack = panelBehaviour.getItem().getDefaultInstance();
        }
    }

    @ModifyArg(method={"lambda$tryDestroySubPanelFirst$3"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlock;popResource(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;)V"))
    private static ItemStack lambda$tryDestroySubPanelFirst$3(ItemStack stack) {
        return extra_gauges$stored$itemStack == null ? stack : extra_gauges$stored$itemStack;
    }

    @ModifyExpressionValue(method={"canBeReplaced"}, at={@At(value="INVOKE", target="Lcom/tterrag/registrate/util/entry/BlockEntry;isIn(Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean canBeReplaced(boolean original, @Local(argsOnly=true) BlockPlaceContext context) {
        return original || context.getItemInHand().getItem() instanceof PanelBlockItem;
    }

    @WrapOperation(method={"canBeReplaced"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;isActive()Z")})
    private boolean canBeReplaced(FactoryPanelBehaviour instance, Operation<Boolean> original) {
        if (instance == null) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance});
    }
}

