/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.api.logistics.board;

import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.createmod.catnip.codecs.CatnipCodecs;
import net.createmod.catnip.gui.ScreenOpener;
import net.liukrast.eg.api.GaugeRegistry;
import net.liukrast.eg.api.logistics.board.BasicPanelScreen;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.mixin.FactoryPanelBehaviourIMixin;
import net.liukrast.eg.mixin.FilteringBehaviourMixin;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPanelBehaviour
extends FactoryPanelBehaviour {
    private final PanelType<?> type;
    private final Map<PanelConnection<?>, Supplier<?>> connections = new Reference2ObjectArrayMap();

    public AbstractPanelBehaviour(ValueBoxTransform valueBoxTransform, PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        this(type, be, slot);
        ((FilteringBehaviourMixin)((Object)this)).setValueBoxTransform(valueBoxTransform);
    }

    public AbstractPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super(be, slot);
        PanelConnectionBuilder builder = new PanelConnectionBuilder();
        this.addConnections(builder);
        this.connections.putAll(builder.map);
        this.type = type;
    }

    public abstract void addConnections(PanelConnectionBuilder var1);

    public <T> Optional<T> getConnectionValue(PanelConnection<T> panelConnection) {
        if (!this.connections.containsKey(panelConnection)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.connections.get(panelConnection).get());
    }

    public boolean hasConnection(PanelConnection<?> connection) {
        return this.connections.containsKey(connection);
    }

    public MutableComponent getDisplayLinkComponent(boolean shortenNumbers) {
        return Component.empty();
    }

    public Map<PanelConnection<?>, Supplier<?>> getConnections() {
        return this.connections;
    }

    public boolean shouldRenderBulb() {
        return false;
    }

    public boolean shouldAllowFilteringBehaviour() {
        return false;
    }

    public abstract Item getItem();

    public abstract PartialModel getModel(FactoryPanelBlock.PanelState var1, FactoryPanelBlock.PanelType var2);

    public void easyWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
    }

    public void easyRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
    }

    public boolean shouldUseRedstoneInsteadOfFilter() {
        return false;
    }

    public PanelType<?> getPanelType() {
        return this.type;
    }

    public void initialize() {
        super.initialize();
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void destroy() {
        super.destroy();
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)smartBlockEntity;
            FactoryPanelBehaviour newBehaviour = new FactoryPanelBehaviour(be, this.slot);
            newBehaviour.active = false;
            this.blockEntity.attachBehaviourLate((BlockEntityBehaviour)newBehaviour);
            be.panels.put(this.slot, newBehaviour);
            be.redraw = true;
            be.lastShape = null;
            be.notifyUpdate();
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        CompoundTag panelTag = nbt.getCompound(CreateLang.asId((String)this.slot.name()));
        if (panelTag.isEmpty()) {
            this.active = false;
            return;
        }
        this.easyRead(panelTag, registries, clientPacket);
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        CompoundTag special = nbt.contains("CustomPanels") ? nbt.getCompound("CustomPanels") : new CompoundTag();
        special.putString(CreateLang.asId((String)this.slot.name()), Objects.requireNonNull(GaugeRegistry.PANEL_REGISTRY.getKey(this.type)).toString());
        nbt.put("CustomPanels", (Tag)special);
        if (!this.active) {
            return;
        }
        CompoundTag panelTag = new CompoundTag();
        panelTag.putBoolean("Satisfied", this.satisfied);
        panelTag.putBoolean("PromisedSatisfied", this.promisedSatisfied);
        panelTag.putBoolean("RedstonePowered", this.redstonePowered);
        panelTag.put("Targeting", (Tag)CatnipCodecUtils.encode((Codec)CatnipCodecs.set((Codec)FactoryPanelPosition.CODEC), (Object)this.targeting).orElseThrow());
        panelTag.put("TargetedBy", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList(this.targetedBy.values())).orElseThrow());
        panelTag.put("TargetedByLinks", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList(this.targetedByLinks.values())).orElseThrow());
        this.easyWrite(panelTag, registries, clientPacket);
        nbt.put(CreateLang.asId((String)this.slot.name()), (Tag)panelTag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void displayScreen(Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new BasicPanelScreen(this));
        }
    }

    public boolean canShortInteract(ItemStack toApply) {
        return this.shouldAllowFilteringBehaviour() && super.canShortInteract(toApply);
    }

    public ItemStack getFilter() {
        return this.getConnectionValue(PanelConnections.FILTER).orElse(ItemStack.EMPTY);
    }

    public void notifyRedstoneOutputs() {
        ((FactoryPanelBehaviourIMixin)((Object)this)).extra_gauges$notifyRedstoneOutputs();
    }

    public boolean acceptsValueSettings() {
        return true;
    }

    public static class PanelConnectionBuilder {
        private final Map<PanelConnection<?>, Supplier<?>> map = new HashMap();

        private PanelConnectionBuilder() {
        }

        public <T> PanelConnectionBuilder put(@NotNull PanelConnection<T> panelConnection, @NotNull Supplier<T> getter) {
            this.map.put(panelConnection, getter);
            return this;
        }
    }
}

