/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.client.SnowClientConfig;

@NotNullByDefault
@Mixin(value={SnowLayerBlock.class})
public class SnowLayerBlockClientMixin
extends Block {
    public SnowLayerBlockClientMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (!SnowClientConfig.particleThroughLeaves || rand.nextInt(32) > 0) {
            return;
        }
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity != null && entity.blockPosition().distSqr((Vec3i)pos) > 256.0) {
            return;
        }
        BlockState stateDown = worldIn.getBlockState(pos.below());
        if (stateDown.is(BlockTags.LEAVES)) {
            double d0 = (double)pos.getX() + rand.nextDouble();
            double d1 = (double)pos.getY() - 0.05;
            double d2 = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

