/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.Hooks;
import snownee.snow.block.OptionalLayerSnowVariant;
import snownee.snow.block.ShapeCaches;
import snownee.snow.block.WaterLoggableSnowVariant;

@NotNullByDefault
public class SnowWallBlock
extends WallBlock
implements WaterLoggableSnowVariant,
OptionalLayerSnowVariant {
    public SnowWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCaches.get(ShapeCaches.COLLIDER, blockState, it -> super.getCollisionShape(it, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty()));
    }

    public VoxelShape getOcclusionShape(BlockState blockState, BlockGetter worldIn, BlockPos pos) {
        return ShapeCaches.get(ShapeCaches.VISUAL, blockState, it -> super.getOcclusionShape(it, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCaches.get(ShapeCaches.OUTLINE, blockState, it -> super.getShape(it, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty()));
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        Hooks.randomTick(state, worldIn, pos, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPTIONAL_LAYERS});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState thatState, LevelAccessor level, BlockPos pos, BlockPos thatPos) {
        state = super.updateShape(state, direction, thatState, level, pos, thatPos);
        if (!Hooks.canSnowSurvive((LevelReader)level, pos)) {
            state = (BlockState)state.setValue((Property)OPTIONAL_LAYERS, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return Hooks.canBeReplaced(state, context);
    }
}

