/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;

public final class GameEvents {
    public static InteractionResult onItemUse(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockPos pos = hitResult.getBlockPos();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof SnowVariant)) {
            return InteractionResult.PASS;
        }
        SnowVariant snowVariant = (SnowVariant)block;
        ItemStack held = player.getMainHandItem();
        if (held.is(Items.DEBUG_STICK) || held.is(Items.SNOW)) {
            return InteractionResult.PASS;
        }
        if (player.hasCorrectToolForDrops(Blocks.SNOW.defaultBlockState())) {
            if (GameEvents.playerCollectSnowball(level, pos, blockState, snowVariant) && !player.isCreative()) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.SNOWBALL));
                held.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (player.isSecondaryUseActive() && SnowCommonConfig.sneakSnowball) {
            if (GameEvents.playerCollectSnowball(level, pos, blockState, snowVariant)) {
                ItemStack snowball = new ItemStack((ItemLike)Items.SNOWBALL);
                if (!(player.isCreative() && player.getInventory().contains(snowball) || player.addItem(snowball))) {
                    player.drop(snowball, false);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (SnowCommonConfig.rightClickToggleFancySnow && !SnowCommonConfig.restoreOriginalBlocks && snowVariant.srm$canRenderOverlay(blockState) && !player.isSecondaryUseActive() && player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
            BlockEntity blockEntity;
            BlockState stateBelow;
            if (snowVariant.srm$renderLayerOffset(blockState) == 0.0 && ((stateBelow = level.getBlockState(pos.below())).is(BlockTags.SNOW) || stateBelow.hasProperty((Property)BlockStateProperties.SNOWY))) {
                return InteractionResult.PASS;
            }
            if (blockState.is(Blocks.SNOW)) {
                level.setBlock(pos, Hooks.copyProperties(blockState, CoreModule.SNOW_BLOCK.defaultBlockState()), 48);
            }
            if (!((blockEntity = level.getBlockEntity(pos)) instanceof SnowBlockEntity)) {
                return InteractionResult.PASS;
            }
            SnowBlockEntity be = (SnowBlockEntity)blockEntity;
            if (!blockState.is(Blocks.SNOW) && blockState.getBlock() instanceof SnowLayerBlock && be.getContainedState().isAir()) {
                level.setBlock(pos, Hooks.copyProperties(blockState, Blocks.SNOW.defaultBlockState()), 48);
            } else {
                be.options.renderOverlay = !be.options.renderOverlay;
                be.refresh();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static boolean playerCollectSnowball(Level level, BlockPos pos, BlockState state, SnowVariant snowVariant) {
        if (level.isClientSide) {
            return false;
        }
        BlockState newState = snowVariant.srm$decreaseLayer(state, level, pos, true);
        level.setBlockAndUpdate(pos, newState);
        int layers = snowVariant.srm$layers(state, (BlockGetter)level, pos);
        BlockState snowState = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(Math.max(layers, 1)));
        level.levelEvent(2001, pos, Block.getId((BlockState)snowState));
        return layers > 0 || !state.hasProperty((Property)SnowVariant.OPTIONAL_LAYERS);
    }

    public static boolean onDestroyedByPlayer(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if ((player == null || player.isCreative()) && blockEntity instanceof SnowBlockEntity) {
            BlockState newState = ((SnowBlockEntity)blockEntity).getContainedState();
            world.setBlockAndUpdate(pos, newState);
            return false;
        }
        return true;
    }
}

