/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncCameraShakePacket
implements CustomPacketPayload {
    ArrayList<CameraShakeData> cameraShakeData;
    public static final CustomPacketPayload.Type<SyncCameraShakePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"sync_camera_shake"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCameraShakePacket> STREAM_CODEC = CustomPacketPayload.codec(SyncCameraShakePacket::write, SyncCameraShakePacket::new);

    public SyncCameraShakePacket(ArrayList<CameraShakeData> cameraShakeData) {
        this.cameraShakeData = cameraShakeData;
    }

    public SyncCameraShakePacket(FriendlyByteBuf buf) {
        this.cameraShakeData = new ArrayList();
        int i = buf.readInt();
        for (int j = 0; j < i; ++j) {
            this.cameraShakeData.add(CameraShakeData.deserializeFromBuffer(buf));
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.cameraShakeData.size());
        for (CameraShakeData data : this.cameraShakeData) {
            data.serializeToBuffer(buf);
        }
    }

    public static void handle(SyncCameraShakePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            CameraShakeManager.clientCameraShakeData = packet.cameraShakeData;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

