/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class DynamicHolder<R extends CodecProvider<? super R>>
implements Supplier<R> {
    public static final ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"empty", (String)"empty");
    protected final DynamicRegistry<R> registry;
    protected final ResourceLocation id;
    @Nullable
    protected R value;

    DynamicHolder(DynamicRegistry<R> registry, ResourceLocation id) {
        this.id = id;
        this.registry = registry;
    }

    public boolean isBound() {
        this.bind();
        return this.value != null;
    }

    @Override
    public R get() {
        this.bind();
        Objects.requireNonNull(this.value, "Trying to access unbound value: " + String.valueOf(this.id));
        return this.value;
    }

    public Optional<R> getOptional() {
        return this.isBound() ? Optional.of(this.get()) : Optional.empty();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean is(ResourceLocation id) {
        return this.id.equals((Object)id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DynamicHolder)) return false;
        DynamicHolder dh = (DynamicHolder)obj;
        if (dh.registry != this.registry) return false;
        if (!dh.id.equals((Object)this.id)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.registry});
    }

    public String toString() {
        return "DynamicHolder{%s / %s}".formatted(this.registry == null ? "null" : this.registry.getPath(), this.id);
    }

    void bind() {
        if (this.value != null) {
            return;
        }
        this.value = this.registry.getValue(this.id);
    }

    void unbind() {
        this.value = null;
    }
}

