/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.datagen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenBuilder {
    protected final Set<String> registrySetModids;
    protected final RegistrySetBuilder registrySet = new RegistrySetBuilder();
    protected final List<DataProviderFactory<?>> providers = new ArrayList();
    protected final Map<ResourceKey<?>, List<ICondition>> conditions = new IdentityHashMap();

    public static DataGenBuilder create(String ... modids) {
        return new DataGenBuilder(modids);
    }

    protected DataGenBuilder(String ... modids) {
        this.registrySetModids = Set.of(modids);
    }

    public <R> DataGenBuilder registry(ResourceKey<? extends Registry<R>> key, RegistrySetBuilder.RegistryBootstrap<R> bootstrap) {
        this.registrySet.add(key, bootstrap);
        return this;
    }

    public DataGenBuilder conditions(ResourceKey<?> key, List<ICondition> conditions) {
        List existing = this.conditions.computeIfAbsent(key, k -> new ArrayList());
        existing.addAll(conditions);
        return this;
    }

    public DataGenBuilder conditions(ResourceKey<?> key, ICondition ... conditions) {
        return this.conditions(key, Arrays.asList(conditions));
    }

    public DataGenBuilder conditions(Map<ResourceKey<?>, List<ICondition>> conditions) {
        for (Map.Entry<ResourceKey<?>, List<ICondition>> entry : conditions.entrySet()) {
            this.conditions(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public <T extends DataProvider> DataGenBuilder provider(DataProviderFactory<T> factory) {
        this.providers.add(factory);
        return this;
    }

    public <T extends DataProvider> DataGenBuilder provider(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> factory) {
        return this.provider((PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper fileHelper) -> (DataProvider)factory.apply(output, registries));
    }

    public <T extends DataProvider> DataGenBuilder provider(DataProvider.Factory<T> factory) {
        return this.provider((PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper fileHelper) -> factory.create(output));
    }

    public void build(GatherDataEvent event) {
        this.registerDataProviders(event);
    }

    protected void registerDataProviders(GatherDataEvent event) {
        PackOutput output = event.getGenerator().getPackOutput();
        DatapackBuiltinEntriesProvider datapackProvider = new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), this.registrySet, this.conditions, this.registrySetModids);
        CompletableFuture registries = datapackProvider.getRegistryProvider();
        DataGenerator generator = event.getGenerator();
        generator.addProvider(true, (DataProvider)datapackProvider);
        for (DataProviderFactory<?> factory : this.providers) {
            generator.addProvider(true, factory.create(output, registries, event.getExistingFileHelper()));
        }
    }

    @FunctionalInterface
    public static interface DataProviderFactory<T extends DataProvider> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, ExistingFileHelper var3);
    }
}

