/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models.ctm;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;

public class ConnectedTextureMap {
    private final EnumMap<Direction, Provider> materials = new EnumMap(Direction.class);
    private final EnumMap<Direction, Int2IntMap> textureMap = new EnumMap(Direction.class);

    public void put(Direction direction, Int2ObjectMap<Material> map) {
        this.materials.put(direction, new MapProvider(map));
    }

    public void put(Direction direction, Material material) {
        this.materials.put(direction, new SimpleProvider(material));
    }

    public int getTexture(Direction direction, int index) {
        return this.textureMap.get(direction).getOrDefault(index, 0);
    }

    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> getter) {
        Object2ObjectArrayMap materialMap = new Object2ObjectArrayMap();
        for (Provider value : this.materials.values()) {
            value.values().forEach(arg_0 -> ConnectedTextureMap.lambda$getTextures$0((Object2ObjectMap)materialMap, getter, arg_0));
        }
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        int id = 0;
        for (Direction value : Direction.values()) {
            Provider provider = this.materials.get(value);
            if (provider == null) {
                this.textureMap.put(value, (Int2IntMap)new Int2IntArrayMap());
                continue;
            }
            Int2IntArrayMap map = new Int2IntArrayMap();
            for (Int2ObjectMap.Entry entry : provider.map().int2ObjectEntrySet()) {
                int index = id++;
                textures.put(index, (Object)((TextureAtlasSprite)materialMap.get(entry.getValue())));
                map.put(entry.getIntKey(), index);
            }
            this.textureMap.put(value, (Int2IntMap)map);
        }
        return textures;
    }

    private static /* synthetic */ void lambda$getTextures$0(Object2ObjectMap materialMap, Function getter, Material material) {
        materialMap.putIfAbsent((Object)material, (Object)((TextureAtlasSprite)getter.apply(material)));
    }

    private record MapProvider(Int2ObjectMap<Material> map) implements Provider
    {
    }

    private record SimpleProvider(Material material) implements Provider
    {
        @Override
        public Int2ObjectMap<Material> map() {
            return Int2ObjectMaps.singleton((int)0, (Object)this.material);
        }
    }

    private static interface Provider {
        public Int2ObjectMap<Material> map();

        default public Collection<Material> values() {
            return this.map().values();
        }
    }
}

