/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.paxi.mixin;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.paxi.PaxiCommon;
import com.yungnickyoung.minecraft.paxi.PaxiRepositorySource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PackRepository.class}, priority=2000)
public abstract class MixinPackRepositoryNeoForge {
    @Final
    @Shadow
    private Set<RepositorySource> sources;

    @Shadow
    private Stream<Pack> getAvailablePacks(Collection<String> names) {
        throw new AssertionError();
    }

    @Inject(at={@At(value="RETURN")}, method={"discoverAvailable"}, cancellable=true)
    private void paxi_removeDuplicatesInAvailableList(CallbackInfoReturnable<Map<String, Pack>> cir) {
        Optional<RepositorySource> repositorySource = this.sources.stream().filter(provider -> provider instanceof PaxiRepositorySource).findFirst();
        if (repositorySource.isEmpty()) {
            PaxiCommon.LOGGER.error("Unable to find Paxi repository source when removing duplicates from available packs. You may see duplicate pack entries in your list of available packs on the Resource Packs screen.");
            return;
        }
        PaxiRepositorySource paxiRepositorySource = (PaxiRepositorySource)repositorySource.get();
        List<String> orderedPaxiPacks = paxiRepositorySource.orderedPaxiPacks;
        LinkedHashMap availablePacks = new LinkedHashMap((Map)cir.getReturnValue());
        HashSet<String> keysToRemove = new HashSet<String>();
        block0: for (String vanillaPackId : availablePacks.keySet()) {
            for (String paxiPackId : orderedPaxiPacks) {
                if (!vanillaPackId.equals("file/" + paxiPackId)) continue;
                keysToRemove.add(vanillaPackId);
                continue block0;
            }
        }
        keysToRemove.forEach(availablePacks::remove);
        cir.setReturnValue(availablePacks);
    }

    @Inject(at={@At(value="RETURN")}, method={"rebuildSelected"}, cancellable=true)
    private void paxi_buildEnabledProfilesNeoForge(Collection<String> enabledNames, CallbackInfoReturnable<List<Pack>> cir) {
        List sortedEnabledPacks = (List)((List)cir.getReturnValue()).stream().collect(Util.toMutableList());
        Optional<RepositorySource> paxiRepositorySource = this.sources.stream().filter(provider -> provider instanceof PaxiRepositorySource).findFirst();
        List<Object> orderedPaxiPacks = new ArrayList();
        if (paxiRepositorySource.isPresent() && !((PaxiRepositorySource)paxiRepositorySource.get()).orderedPaxiPacks.isEmpty()) {
            orderedPaxiPacks = this.getAvailablePacks(((PaxiRepositorySource)paxiRepositorySource.get()).orderedPaxiPacks).flatMap(Pack::streamSelfAndChildren).toList();
            sortedEnabledPacks.removeAll(orderedPaxiPacks);
        }
        for (Pack pack : orderedPaxiPacks) {
            if (!pack.isRequired() || sortedEnabledPacks.contains(pack)) continue;
            int indexInserted = pack.getDefaultPosition().insert(sortedEnabledPacks, (Object)pack, Pack::selectionConfig, false);
            sortedEnabledPacks.addAll(indexInserted + 1, pack.getChildren());
        }
        cir.setReturnValue((Object)ImmutableList.copyOf((Collection)sortedEnabledPacks));
    }
}

