/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.paxi;

import com.yungnickyoung.minecraft.paxi.PaxiCommon;
import com.yungnickyoung.minecraft.paxi.PaxiRepositorySource;
import com.yungnickyoung.minecraft.paxi.module.ConfigModuleNeoForge;
import java.io.File;
import java.nio.file.Paths;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@Mod(value="paxi")
public class PaxiNeoForge {
    public PaxiNeoForge(IEventBus eventBus, ModContainer container) {
        PaxiCommon.BASE_GAME_DIRECTORY = FMLPaths.GAMEDIR.get().toFile();
        PaxiCommon.BASE_PACK_DIRECTORY = new File(FMLPaths.CONFIGDIR.get().toString(), "paxi");
        PaxiCommon.DATA_PACK_DIRECTORY = Paths.get(PaxiCommon.BASE_PACK_DIRECTORY.toString(), "datapacks");
        PaxiCommon.RESOURCE_PACK_DIRECTORY = Paths.get(PaxiCommon.BASE_PACK_DIRECTORY.toString(), "resourcepacks");
        PaxiCommon.DATAPACK_ORDERING_FILE = new File(PaxiCommon.BASE_PACK_DIRECTORY, "datapack_load_order.json");
        PaxiCommon.RESOURCEPACK_ORDERING_FILE = new File(PaxiCommon.BASE_PACK_DIRECTORY, "resourcepack_load_order.json");
        PaxiCommon.init();
        ConfigModuleNeoForge.init(eventBus, container);
        eventBus.addListener(PaxiNeoForge::addPaxiPackSource);
    }

    private static void addPaxiPackSource(AddPackFindersEvent event) {
        switch (event.getPackType()) {
            case CLIENT_RESOURCES: {
                event.addRepositorySource((RepositorySource)new PaxiRepositorySource(PaxiCommon.RESOURCE_PACK_DIRECTORY, PackType.CLIENT_RESOURCES, PaxiCommon.RESOURCEPACK_ORDERING_FILE));
                break;
            }
            case SERVER_DATA: {
                event.addRepositorySource((RepositorySource)new PaxiRepositorySource(PaxiCommon.DATA_PACK_DIRECTORY, PackType.SERVER_DATA, PaxiCommon.DATAPACK_ORDERING_FILE));
            }
        }
    }
}

