/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.inventorybridge;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.content.inventorybridge.InventoryBridgeBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.NotNull;

public class InventoryBridgeBlock
extends Block
implements IBE<InventoryBridgeBlockEntity>,
IWrenchable {
    public static BooleanProperty ATTACHED_POSITIVE = BooleanProperty.create((String)"attached_positive");
    public static BooleanProperty ATTACHED_NEGATIVE = BooleanProperty.create((String)"attached_negative");
    public static EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    public InventoryBridgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ATTACHED_POSITIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHED_NEGATIVE, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{ATTACHED_POSITIVE, ATTACHED_NEGATIVE, AXIS}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        BlockCapability itemCap = Capabilities.ItemHandler.BLOCK;
        Direction preferredFacing = null;
        for (Direction face : context.getNearestLookingDirections()) {
            BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos().relative(face));
            if (be == null || context.getLevel().getCapability(itemCap, be.getBlockPos(), null) == null) continue;
            preferredFacing = face;
            break;
        }
        if (preferredFacing == null) {
            preferredFacing = context.getNearestLookingDirection();
        }
        return (BlockState)state.setValue(AXIS, (Comparable)preferredFacing.getAxis());
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        this.withBlockEntityDo((BlockGetter)worldIn, pos, InventoryBridgeBlockEntity::updateConnectedInventory);
    }

    public void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, InventoryBridgeBlockEntity::updateConnectedInventory);
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        BlockPos diff = pFromPos.subtract((Vec3i)pPos);
        Direction fromSide = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
        if (fromSide == null) {
            pLevel.updateNeighborsAt(pPos, (Block)this);
        } else {
            pLevel.updateNeighborsAtExceptFromFacing(pPos, (Block)this, fromSide);
        }
    }

    public static Direction getNegativeTarget(BlockState state) {
        return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
    }

    public static Direction getPositiveTarget(BlockState state) {
        return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, @NotNull Level worldIn, @NotNull BlockPos pos) {
        BlockPos pos1 = pos.relative(InventoryBridgeBlock.getNegativeTarget(blockState));
        BlockPos pos2 = pos.relative(InventoryBridgeBlock.getPositiveTarget(blockState));
        BlockState target1 = worldIn.getBlockState(pos1);
        BlockState target2 = worldIn.getBlockState(pos2);
        int total = 0;
        if (((Boolean)blockState.getValue((Property)ATTACHED_NEGATIVE)).booleanValue() && !target1.is((Block)this) && target1.hasAnalogOutputSignal()) {
            total += target1.getAnalogOutputSignal(worldIn, pos1);
        }
        if (((Boolean)blockState.getValue((Property)ATTACHED_POSITIVE)).booleanValue() && !target2.is((Block)this) && target2.hasAnalogOutputSignal()) {
            total += target2.getAnalogOutputSignal(worldIn, pos2);
        }
        return total / 2;
    }

    public Class<InventoryBridgeBlockEntity> getBlockEntityClass() {
        return InventoryBridgeBlockEntity.class;
    }

    public BlockEntityType<? extends InventoryBridgeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.INVENTORY_BRIDGE.get();
    }
}

