/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.ContraptionHandler;
import com.simibubi.create.content.contraptions.actors.seat.ContraptionPlayerPassengerRotation;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsHandler;
import com.simibubi.create.content.contraptions.chassis.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.minecart.CouplingHandlerClient;
import com.simibubi.create.content.contraptions.minecart.CouplingPhysics;
import com.simibubi.create.content.contraptions.minecart.CouplingRenderer;
import com.simibubi.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.render.ContraptionRenderInfoManager;
import com.simibubi.create.content.contraptions.wrench.RadialWrenchHandler;
import com.simibubi.create.content.decoration.girder.GirderWrenchBehavior;
import com.simibubi.create.content.equipment.armor.BacktankArmorLayer;
import com.simibubi.create.content.equipment.armor.CardboardArmorStealthOverlay;
import com.simibubi.create.content.equipment.armor.DivingHelmetItem;
import com.simibubi.create.content.equipment.armor.NetheriteBacktankFirstPersonRenderer;
import com.simibubi.create.content.equipment.armor.NetheriteDivingHandler;
import com.simibubi.create.content.equipment.armor.RemainingAirOverlay;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.equipment.clipboard.ClipboardValueSettingsHandler;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripRenderHandler;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.equipment.hats.CreateHatArmorLayer;
import com.simibubi.create.content.equipment.potatoCannon.PotatoCannonItemRenderer;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandlerClient;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.content.equipment.zapper.terrainzapper.WorldshaperRenderHandler;
import com.simibubi.create.content.kinetics.KineticDebugger;
import com.simibubi.create.content.kinetics.belt.item.BeltConnectorHandler;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorConnectionHandler;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorInteractionHandler;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorRidingHandler;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointHandler;
import com.simibubi.create.content.kinetics.turntable.TurntableHandler;
import com.simibubi.create.content.logistics.depot.EjectorTargetHandler;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.simibubi.create.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedClientHandler;
import com.simibubi.create.content.logistics.tableCloth.TableClothOverlayRenderer;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.redstone.displayLink.ClickToLinkBlockItem;
import com.simibubi.create.content.redstone.link.LinkRenderer;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerClientHandler;
import com.simibubi.create.content.trains.CameraDistanceModifier;
import com.simibubi.create.content.trains.TrainHUD;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.CarriageCouplingRenderer;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfoReloadListener;
import com.simibubi.create.content.trains.track.CurvedTrackInteraction;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackPlacement;
import com.simibubi.create.content.trains.track.TrackPlacementOverlay;
import com.simibubi.create.content.trains.track.TrackTargetingClient;
import com.simibubi.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueRenderer;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.networking.LeftClickPacket;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.CameraAngleAnimationService;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.TickBasedCache;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.createmod.catnip.levelWrappers.WrappedClientLevel;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onTickPre(ClientTickEvent.Pre event) {
        ClientEvents.onTick(true);
    }

    @SubscribeEvent
    public static void onTickPost(ClientTickEvent.Post event) {
        ClientEvents.onTick(false);
    }

    public static void onTick(boolean isPreEvent) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        ClientLevel world = Minecraft.getInstance().level;
        if (isPreEvent) {
            LinkedControllerClientHandler.tick();
            ControlsHandler.tick();
            AirCurrent.Client.tickClientPlayerSounds();
            return;
        }
        SoundScapes.tick();
        CreateClient.SCHEMATIC_SENDER.tick();
        CreateClient.SCHEMATIC_AND_QUILL_HANDLER.tick();
        CreateClient.GLUE_HANDLER.tick();
        CreateClient.SCHEMATIC_HANDLER.tick();
        CreateClient.ZAPPER_RENDER_HANDLER.tick();
        CreateClient.POTATO_CANNON_RENDER_HANDLER.tick();
        CreateClient.SOUL_PULSE_EFFECT_HANDLER.tick((Level)world);
        CreateClient.RAILWAYS.clientTick();
        ContraptionHandler.tick((Level)world);
        CapabilityMinecartController.tick((Level)world);
        CouplingPhysics.tick((Level)world);
        ServerSpeedProvider.clientTick();
        BeltConnectorHandler.tick();
        FilteringRenderer.tick();
        LinkRenderer.tick();
        ScrollValueRenderer.tick();
        ChassisRangeDisplay.tick();
        EdgeInteractionRenderer.tick();
        GirderWrenchBehavior.tick();
        WorldshaperRenderHandler.tick();
        CouplingHandlerClient.tick();
        CouplingRenderer.tickDebugModeRenders();
        KineticDebugger.tick();
        ExtendoGripRenderHandler.tick();
        ArmInteractionPointHandler.tick();
        EjectorTargetHandler.tick();
        ContraptionRenderInfoManager.tickFor((Level)world);
        BlueprintOverlayRenderer.tick();
        ToolboxHandlerClient.clientTick();
        RadialWrenchHandler.clientTick();
        TrackTargetingClient.clientTick();
        TrackPlacement.clientTick();
        TrainRelocator.clientTick();
        ClickToLinkBlockItem.clientTick();
        CurvedTrackInteraction.clientTick();
        CameraDistanceModifier.tick();
        CameraAngleAnimationService.tick();
        TrainHUD.tick();
        ClipboardValueSettingsHandler.clientTick();
        CreateClient.VALUE_SETTINGS_HANDLER.tick();
        ScrollValueHandler.tick();
        NetheriteBacktankFirstPersonRenderer.clientTick();
        ContraptionPlayerPassengerRotation.tick();
        ChainConveyorInteractionHandler.clientTick();
        ChainConveyorRidingHandler.clientTick();
        ChainConveyorConnectionHandler.clientTick();
        PackagePortTargetSelectionHandler.tick();
        LogisticallyLinkedClientHandler.tick();
        TableClothOverlayRenderer.tick();
        CardboardArmorStealthOverlay.clientTick();
        FactoryPanelConnectionHandler.clientTick();
        TickBasedCache.clientTick();
    }

    @SubscribeEvent
    public static void onJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        CreateClient.checkGraphicsFanciness();
    }

    @SubscribeEvent
    public static void onLeave(ClientPlayerNetworkEvent.LoggingOut event) {
        CreateClient.RAILWAYS.cleanUp();
    }

    @SubscribeEvent
    public static void onLoadWorld(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (world.isClientSide() && world instanceof ClientLevel && !(world instanceof WrappedClientLevel)) {
            CreateClient.invalidateRenderers();
            AnimationTickHolder.reset();
        }
    }

    @SubscribeEvent
    public static void onUnloadWorld(LevelEvent.Unload event) {
        if (!event.getLevel().isClientSide()) {
            return;
        }
        CreateClient.invalidateRenderers();
        CreateClient.SOUL_PULSE_EFFECT_HANDLER.refresh();
        AnimationTickHolder.reset();
        ControlsHandler.levelUnloaded(event.getLevel());
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        ms.pushPose();
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        TrackBlockOutline.drawCurveSelection(ms, (MultiBufferSource)buffer, camera);
        TrackTargetingClient.render(ms, (SuperRenderTypeBuffer)buffer, camera);
        CouplingRenderer.renderAll(ms, (MultiBufferSource)buffer, camera);
        CarriageCouplingRenderer.renderAll(ms, (MultiBufferSource)buffer, camera);
        CreateClient.SCHEMATIC_HANDLER.render(ms, (SuperRenderTypeBuffer)buffer, camera);
        ChainConveyorInteractionHandler.drawCustomBlockSelection(ms, (MultiBufferSource)buffer, camera);
        buffer.draw();
        RenderSystem.enableCull();
        ms.popPose();
        ContraptionPlayerPassengerRotation.frame();
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        if (CameraAngleAnimationService.isYawAnimating()) {
            event.setYaw(CameraAngleAnimationService.getYaw(partialTicks));
        }
        if (CameraAngleAnimationService.isPitchAnimating()) {
            event.setPitch(CameraAngleAnimationService.getPitch(partialTicks));
        }
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)AllConfigs.client().tooltips.get()).booleanValue()) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        Item item = event.getItemStack().getItem();
        TooltipModifier modifier = TooltipModifier.REGISTRY.get(item);
        if (modifier != null && modifier != TooltipModifier.EMPTY) {
            modifier.modify(event);
        }
        SequencedAssemblyRecipe.addToTooltip(event);
    }

    @SubscribeEvent
    public static void onRenderFramePre(ClientTickEvent.Pre event) {
        ClientEvents.onRenderFrame(true);
    }

    @SubscribeEvent
    public static void onRenderFramePost(ClientTickEvent.Post event) {
        ClientEvents.onRenderFrame(false);
    }

    public static void onRenderFrame(boolean isPreEvent) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        TurntableHandler.gameRenderFrame();
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity entity;
        if (event.getEntityMounting() != Minecraft.getInstance().player) {
            return;
        }
        if (event.isDismounting()) {
            CameraDistanceModifier.reset();
            return;
        }
        if (!event.isMounting() || !((entity = event.getEntityBeingMounted()) instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity carriage = (CarriageContraptionEntity)entity;
        CameraDistanceModifier.zoomOut();
    }

    protected static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }

    @SubscribeEvent
    public static void getFogDensity(ViewportEvent.RenderFog event) {
        Camera camera = event.getCamera();
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos blockPos = camera.getBlockPosition();
        FluidState fluidState = level.getFluidState(blockPos);
        if (camera.getPosition().y >= (double)((float)blockPos.getY() + fluidState.getHeight((BlockGetter)level, blockPos))) {
            return;
        }
        Fluid fluid = fluidState.getType();
        Entity entity = camera.getEntity();
        if (entity.isSpectator()) {
            return;
        }
        ItemStack divingHelmet = DivingHelmetItem.getWornItem(entity);
        if (!divingHelmet.isEmpty()) {
            if (FluidHelper.isWater(fluid)) {
                event.scaleFarPlaneDistance(6.25f);
                event.setCanceled(true);
                return;
            }
            if (FluidHelper.isLava(fluid) && NetheriteDivingHandler.isNetheriteDivingHelmet(divingHelmet)) {
                event.setNearPlaneDistance(-4.0f);
                event.setFarPlaneDistance(20.0f);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof ZapperItem) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)LeftClickPacket.INSTANCE);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)CreateClient.RESOURCE_RELOAD_LISTENER);
            event.registerReloadListener((PreparableReloadListener)TrainHatInfoReloadListener.LISTENER);
        }

        @SubscribeEvent
        public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
            EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            BacktankArmorLayer.registerOnAll(dispatcher);
            CreateHatArmorLayer.registerOnAll(dispatcher);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
            event.registerAbove(VanillaGuiLayers.AIR_LEVEL, Create.asResource("remaining_air"), (LayeredDraw.Layer)RemainingAirOverlay.INSTANCE);
            event.registerAbove(VanillaGuiLayers.EXPERIENCE_BAR, Create.asResource("train_hud"), TrainHUD.OVERLAY);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Create.asResource("value_settings"), (LayeredDraw.Layer)CreateClient.VALUE_SETTINGS_HANDLER);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Create.asResource("track_placement"), (LayeredDraw.Layer)TrackPlacementOverlay.INSTANCE);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Create.asResource("goggle_info"), GoggleOverlayRenderer.OVERLAY);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Create.asResource("blueprint"), BlueprintOverlayRenderer.OVERLAY);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Create.asResource("linked_controller"), LinkedControllerClientHandler.OVERLAY);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Create.asResource("schematic"), (LayeredDraw.Layer)CreateClient.SCHEMATIC_HANDLER);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Create.asResource("toolbox"), ToolboxHandlerClient.OVERLAY);
        }

        @SubscribeEvent
        public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
            event.register(AllItems.POTATO_CANNON, PotatoCannonItemRenderer.DECORATOR);
        }

        @SubscribeEvent
        public static void onLoadComplete(FMLLoadCompleteEvent event) {
            ModContainer createContainer = (ModContainer)ModList.get().getModContainerById("create").orElseThrow(() -> new IllegalStateException("Create mod container missing on LoadComplete"));
            Supplier<IConfigScreenFactory> configScreen = () -> (mc, previousScreen) -> new BaseConfigScreen(previousScreen, "create");
            createContainer.registerExtensionPoint(IConfigScreenFactory.class, configScreen);
        }
    }
}

