/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ChangeThrottleInstruction
extends ScheduleInstruction {
    public ChangeThrottleInstruction() {
        this.data.putInt("Value", 100);
    }

    @Override
    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)this.icon(), (Object)this.formatted());
    }

    private MutableComponent formatted() {
        return Component.literal((String)(this.intData("Value") + "%"));
    }

    @Override
    public ResourceLocation getId() {
        return Create.asResource("throttle");
    }

    @Override
    public ItemStack getSecondLineIcon() {
        return this.icon();
    }

    @Override
    public boolean supportsConditions() {
        return false;
    }

    @Override
    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule." + type + "." + this.getId().getPath() + ".summary", this.formatted().withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.GOLD));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 50, (si, l) -> {
            si.withRange(5, 101).withStepFunction(c -> c.shift ? 25 : 5).titled(CreateLang.translateDirect("schedule.instruction.throttle_edit_box", new Object[0]));
            l.withSuffix("%");
        }, "Value");
    }

    public float getThrottle() {
        return (float)this.intData("Value") / 100.0f;
    }

    private ItemStack icon() {
        return AllBlocks.TRAIN_CONTROLS.asStack();
    }

    @Override
    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.instruction.throttle_edit_box", new Object[0]), (Object)CreateLang.translateDirect("schedule.instruction.throttle_edit_box_1", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    @Override
    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime, Level level) {
        runtime.train.throttle = this.getThrottle();
        runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
        ++runtime.currentEntry;
        return null;
    }
}

