/*
 * Decompiled with CFR 0.152.
 */
package net.zhaiji.catburger.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.zhaiji.catburger.config.CatBurgerCommonConfig;
import net.zhaiji.catburger.init.InitItem;
import net.zhaiji.catburger.network.packet.PlayerDeathPacket;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@EventBusSubscriber(modid="catburger")
public class CatBurgerItem
extends Item
implements ICurioItem {
    public CatBurgerItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            FoodData foodData;
            int foodLevel;
            Player player = (Player)livingEntity;
            if (player.tickCount % CatBurgerCommonConfig.curios_cooldown == 0 && (foodLevel = (foodData = player.getFoodData()).getFoodLevel()) < CatBurgerCommonConfig.food_max_restoration) {
                foodData.setFoodLevel(Math.min(foodLevel + CatBurgerCommonConfig.food_restoration_form_curios, CatBurgerCommonConfig.food_max_restoration));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.catburger.cat_burger.tooltip"));
    }

    @SubscribeEvent
    public static void LivingDeathEvent(LivingDeathEvent event) {
        Player player;
        if (!CatBurgerCommonConfig.totem_effect_active) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).getCooldowns().isOnCooldown((Item)InitItem.CAT_BURGER.get())) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
                if (!iCuriosItemHandler.findCurios((Item)InitItem.CAT_BURGER.get()).isEmpty()) {
                    player.setHealth((float)CatBurgerCommonConfig.health_restoration_form_totem);
                    player.getFoodData().setFoodLevel(CatBurgerCommonConfig.food_restoration_form_totem);
                    player.getFoodData().setSaturation((float)CatBurgerCommonConfig.saturation_restoration_form_totem);
                    player.getCooldowns().addCooldown((Item)InitItem.CAT_BURGER.get(), CatBurgerCommonConfig.totem_cooldown);
                    player.level().broadcastEntityEvent((Entity)player, (byte)35);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new PlayerDeathPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void PlayerWakeUpEvent(PlayerWakeUpEvent event) {
        if (!CatBurgerCommonConfig.wake_up_can_reset_cooldown) {
            return;
        }
        Player player = event.getEntity();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            if (!iCuriosItemHandler.findCurios((Item)InitItem.CAT_BURGER.get()).isEmpty()) {
                player.getCooldowns().removeCooldown((Item)InitItem.CAT_BURGER.get());
            }
        });
    }
}

