/*
 * Decompiled with CFR 0.152.
 */
package net.zhaiji.catburger.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="catburger", bus=EventBusSubscriber.Bus.MOD)
public class CatBurgerCommonConfig {
    public static boolean totem_effect_active;
    public static boolean wake_up_can_reset_cooldown;
    public static int totem_cooldown;
    public static int curios_cooldown;
    public static int food_restoration_form_curios;
    public static int food_max_restoration;
    public static int health_restoration_form_totem;
    public static int food_restoration_form_totem;
    public static int saturation_restoration_form_totem;
    private static final ModConfigSpec.Builder BUILDER;
    private static final ModConfigSpec.BooleanValue TOTEM_EFFECT_ACTIVE;
    private static final ModConfigSpec.BooleanValue WAKE_UP_CAN_RESET_COOLDOWN;
    private static final ModConfigSpec.IntValue TOTEM_COOLDOWN_VALUE;
    private static final ModConfigSpec.IntValue CURIOS_COOLDOWN_VALUE;
    private static final ModConfigSpec.IntValue FOOD_RESTORATION_VALUE;
    private static final ModConfigSpec.IntValue FOOD_MAX_RESTORATION;
    private static final ModConfigSpec.IntValue HEALTH_VALUE;
    private static final ModConfigSpec.IntValue FOOD_VALUE;
    private static final ModConfigSpec.IntValue SATURATION_VALUE;
    public static final ModConfigSpec SPEC;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            totem_effect_active = (Boolean)TOTEM_EFFECT_ACTIVE.get();
            wake_up_can_reset_cooldown = (Boolean)WAKE_UP_CAN_RESET_COOLDOWN.get();
            totem_cooldown = (Integer)TOTEM_COOLDOWN_VALUE.get();
            curios_cooldown = (Integer)CURIOS_COOLDOWN_VALUE.get();
            food_restoration_form_curios = (Integer)FOOD_RESTORATION_VALUE.get();
            food_max_restoration = (Integer)FOOD_MAX_RESTORATION.get();
            health_restoration_form_totem = (Integer)HEALTH_VALUE.get();
            food_restoration_form_totem = (Integer)FOOD_VALUE.get();
            saturation_restoration_form_totem = (Integer)SATURATION_VALUE.get();
        }
    }

    static {
        BUILDER = new ModConfigSpec.Builder().comment("config").push("Config");
        TOTEM_EFFECT_ACTIVE = BUILDER.comment("totem effect active?").define("active", true);
        WAKE_UP_CAN_RESET_COOLDOWN = BUILDER.comment("wake up can reset totem effect cooldown?").define("can_reset", true);
        TOTEM_COOLDOWN_VALUE = BUILDER.comment("totem effect cooldown(tick)").defineInRange("totem_cooldown", 36000, 0, Integer.MAX_VALUE);
        CURIOS_COOLDOWN_VALUE = BUILDER.comment("totem effect cooldown(tick)").defineInRange("curios_cooldown", 1200, 0, Integer.MAX_VALUE);
        FOOD_RESTORATION_VALUE = BUILDER.comment("food restoration form curios effect").defineInRange("foodRestoration", 1, 0, 20);
        FOOD_MAX_RESTORATION = BUILDER.comment("food max restoration").defineInRange("foodMaxRestoration", 18, 1, 20);
        HEALTH_VALUE = BUILDER.comment("health restoration form totem effect").defineInRange("health", 20, 0, Integer.MAX_VALUE);
        FOOD_VALUE = BUILDER.comment("food restoration form totem effect").defineInRange("foodLevel", 20, 0, 20);
        SATURATION_VALUE = BUILDER.comment("saturation restoration form totem effect").defineInRange("saturation", 20, 0, 20);
        SPEC = BUILDER.build();
    }
}

