/*
 * Decompiled with CFR 0.152.
 */
package net.zhaiji.catburger.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="catburger", bus=EventBusSubscriber.Bus.MOD)
public class CatBurgerClientConfig {
    public static double scale;
    public static double float_distance;
    public static double time;
    public static double front_back_offset;
    public static double vertical_offset;
    public static double left_right_offset;
    private static final ModConfigSpec.Builder BUILDER;
    private static final ModConfigSpec.DoubleValue SCALE;
    private static final ModConfigSpec.DoubleValue FLOAT_DISTANCE;
    private static final ModConfigSpec.DoubleValue FLOAT_CYCLE_DURATION;
    private static final ModConfigSpec.DoubleValue FRONT_BACK_OFFSET;
    private static final ModConfigSpec.DoubleValue VERTICAL_OFFSET;
    private static final ModConfigSpec.DoubleValue LEFT_RIGHT_OFFSET;
    public static final ModConfigSpec SPEC;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            scale = (Double)SCALE.get();
            float_distance = (Double)FLOAT_DISTANCE.get();
            time = (Double)FLOAT_CYCLE_DURATION.get();
            front_back_offset = (Double)FRONT_BACK_OFFSET.get();
            vertical_offset = (Double)VERTICAL_OFFSET.get();
            left_right_offset = (Double)LEFT_RIGHT_OFFSET.get();
        }
    }

    static {
        BUILDER = new ModConfigSpec.Builder().comment("CatBurger Client Config").push("Config");
        SCALE = BUILDER.comment("scale").defineInRange("scale", 0.7, 0.1, 10.0);
        FLOAT_DISTANCE = BUILDER.comment("float distance (blocks)").defineInRange("float_distance", 0.1, 0.0, 100.0);
        FLOAT_CYCLE_DURATION = BUILDER.comment("time to complete a float cycle (tick) ").defineInRange("time", 40.0, 0.0, 100.0);
        FRONT_BACK_OFFSET = BUILDER.comment("front & back offset").defineInRange("front_back_offset", 0.0, -100.0, 100.0);
        VERTICAL_OFFSET = BUILDER.comment("vertical offset").defineInRange("vertical_offset", 0.0, -100.0, 100.0);
        LEFT_RIGHT_OFFSET = BUILDER.comment("left & right offset").defineInRange("left_right_offset", -0.8, -100.0, 100.0);
        SPEC = BUILDER.build();
    }
}

