/*
 * Decompiled with CFR 0.152.
 */
package net.zhaiji.catburger.client.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.zhaiji.catburger.client.render.CatBurgerRenderer;
import net.zhaiji.catburger.config.CatBurgerClientConfig;
import net.zhaiji.catburger.init.InitItem;
import org.joml.Quaternionf;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class YSMCompat {
    private static final String YSM_ID = "yes_steve_model";
    private static float netHeadYaw;
    private static float headPitch;

    public static boolean isLoad() {
        return LoadingModList.get().getModFileById(YSM_ID) != null;
    }

    private static void getHeadRot(float partialTicks, LivingEntity entity) {
        float yaw = Mth.rotLerp((float)partialTicks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float pitch = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        netHeadYaw = yaw = Mth.wrapDegrees((float)yaw);
        headPitch = pitch;
    }

    public static void RenderLivingEvent(RenderLivingEvent.Post event) {
        Item item = (Item)InitItem.CAT_BURGER.get();
        LivingEntity livingEntity = event.getEntity();
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource renderTypeBuffer = event.getMultiBufferSource();
        int light = event.getPackedLight();
        CuriosApi.getCuriosInventory((LivingEntity)livingEntity).ifPresent(iCuriosItemHandler -> {
            List list = iCuriosItemHandler.findCurios(item);
            if (!list.isEmpty() && ((SlotResult)list.getFirst()).slotContext().visible()) {
                Minecraft minecraft = Minecraft.getInstance();
                BakedModel model = CatBurgerRenderer.getModel();
                matrixStack.pushPose();
                YSMCompat.getHeadRot(event.getPartialTick(), livingEntity);
                double yawRadians = Math.toRadians(-netHeadYaw);
                double xOffset = 0.0;
                double yOffset = 0.0;
                double zOffset = 0.0;
                xOffset -= Math.cos(yawRadians + 1.5707963267948966) * CatBurgerClientConfig.front_back_offset;
                zOffset += Math.sin(yawRadians + 1.5707963267948966) * CatBurgerClientConfig.front_back_offset;
                yOffset += CatBurgerRenderer.getFloatSpeed(livingEntity);
                yOffset += CatBurgerClientConfig.vertical_offset;
                yOffset = livingEntity.isCrouching() ? (yOffset += 1.0) : (yOffset += 1.5);
                matrixStack.translate(xOffset += Math.cos(yawRadians) * CatBurgerClientConfig.left_right_offset, yOffset, zOffset -= Math.sin(yawRadians) * CatBurgerClientConfig.left_right_offset);
                float scale = (float)CatBurgerClientConfig.scale;
                matrixStack.scale(scale, scale, scale);
                matrixStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(180.0)));
                matrixStack.mulPose(Axis.YP.rotationDegrees(-netHeadYaw));
                matrixStack.mulPose(Axis.XP.rotationDegrees(-headPitch));
                minecraft.getItemRenderer().render(new ItemStack((ItemLike)item), ItemDisplayContext.HEAD, false, matrixStack, renderTypeBuffer, light, OverlayTexture.NO_OVERLAY, model);
                matrixStack.popPose();
            }
        });
    }
}

