/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.client.KeyBindings;
import com.direwolf20.buildinggadgets2.client.screen.widgets.GuiIconActionable;
import com.direwolf20.buildinggadgets2.client.screen.widgets.IncrementalSliderWidget;
import com.direwolf20.buildinggadgets2.common.network.data.AnchorPayload;
import com.direwolf20.buildinggadgets2.common.network.data.DestructionRangesPayload;
import com.direwolf20.buildinggadgets2.common.network.data.RenderChangePayload;
import com.direwolf20.buildinggadgets2.common.network.data.ToggleSettingPayload;
import com.direwolf20.buildinggadgets2.common.network.data.UndoPayload;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class DestructionGUI
extends Screen {
    private final Set<IncrementalSliderWidget> sliders = new HashSet<IncrementalSliderWidget>();
    private IncrementalSliderWidget left;
    private IncrementalSliderWidget right;
    private IncrementalSliderWidget up;
    private IncrementalSliderWidget down;
    private IncrementalSliderWidget depth;
    private int originalLeft;
    private int originalRight;
    private int originalUp;
    private int originalDown;
    private int originalDepth;
    private Button confirm;
    private String sizeString = "";
    private boolean isValidSize = true;
    private boolean keyDown = false;
    private final ItemStack destructionGadget;
    private Button renderTypeButton;
    private GadgetNBT.RenderTypes renderType;

    public DestructionGUI(ItemStack tool, boolean keyDown) {
        super((Component)Component.empty());
        this.destructionGadget = tool;
        this.keyDown = keyDown;
        this.renderType = GadgetNBT.getRenderType(tool);
    }

    public void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"buildinggadgets2.screen.revert"), b -> {
            this.depth.setValue(this.originalDepth);
            this.right.setValue(this.originalRight);
            this.left.setValue(this.originalLeft);
            this.up.setValue(this.originalUp);
            this.down.setValue(this.originalDown);
            this.sendPacket();
        }).pos(x - 30 + 32, y + 65).size(60, 20).build());
        GuiIconActionable undo_button = new GuiIconActionable(x - 55, y - 75, "undo", (Component)Component.translatable((String)"buildinggadgets2.radialmenu.undo"), false, send -> {
            if (send.booleanValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UndoPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return false;
        });
        this.addRenderableWidget((GuiEventListener)undo_button);
        GuiIconActionable anchorButton = new GuiIconActionable(x - 25, y - 75, "anchor", (Component)Component.translatable((String)"buildinggadgets2.radialmenu.anchor"), true, send -> {
            if (send.booleanValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new AnchorPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return !GadgetNBT.getAnchorPos(this.destructionGadget).equals((Object)GadgetNBT.nullPos);
        });
        this.addRenderableWidget((GuiEventListener)anchorButton);
        GuiIconActionable affectTiles = new GuiIconActionable(x + 5, y - 75, "affecttiles", (Component)Component.translatable((String)"buildinggadgets2.screen.affecttiles"), true, send -> {
            if (send.booleanValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ToggleSettingPayload(GadgetNBT.ToggleableSettings.AFFECT_TILES.getName()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return GadgetNBT.getSetting(this.destructionGadget, GadgetNBT.ToggleableSettings.AFFECT_TILES.getName());
        });
        this.addRenderableWidget((GuiEventListener)affectTiles);
        GuiIconActionable rayTrace = new GuiIconActionable(x + 35, y - 75, "raytrace_fluid", (Component)Component.translatable((String)"buildinggadgets2.radialmenu.raytracefluids"), true, send -> {
            if (send.booleanValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ToggleSettingPayload(GadgetNBT.ToggleableSettings.RAYTRACE_FLUID.getName()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return GadgetNBT.getSetting(this.destructionGadget, GadgetNBT.ToggleableSettings.RAYTRACE_FLUID.getName());
        });
        this.addRenderableWidget((GuiEventListener)rayTrace);
        this.renderTypeButton = new GuiIconActionable(x + 65, y - 75, "raytrace_fluid", (Component)Component.translatable((String)this.renderType.getLang()), false, send -> {
            if (send.booleanValue()) {
                this.renderType = this.renderType.next();
                this.renderTypeButton.setMessage((Component)Component.translatable((String)this.renderType.getLang()));
                PacketDistributor.sendToServer((CustomPacketPayload)new RenderChangePayload(this.renderType.getPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return false;
        });
        this.addRenderableWidget((GuiEventListener)this.renderTypeButton);
        this.sliders.clear();
        this.depth = this.createSlider(x - 35, y - 7, Component.translatable((String)"buildinggadgets2.screen.depth"), GadgetNBT.getToolValue(this.destructionGadget, GadgetNBT.IntSettings.DEPTH.getName()));
        this.sliders.add(this.depth);
        this.right = this.createSlider(x + 75, y - 7, Component.translatable((String)"buildinggadgets2.screen.right"), GadgetNBT.getToolValue(this.destructionGadget, GadgetNBT.IntSettings.RIGHT.getName()));
        this.sliders.add(this.right);
        this.left = this.createSlider(x - 140 - 5, y - 7, Component.translatable((String)"buildinggadgets2.screen.left"), GadgetNBT.getToolValue(this.destructionGadget, GadgetNBT.IntSettings.LEFT.getName()));
        this.sliders.add(this.left);
        this.up = this.createSlider(x - 35, y - 35, Component.translatable((String)"buildinggadgets2.screen.up"), GadgetNBT.getToolValue(this.destructionGadget, GadgetNBT.IntSettings.UP.getName()));
        this.sliders.add(this.up);
        this.down = this.createSlider(x - 35, y + 20, Component.translatable((String)"buildinggadgets2.screen.down"), GadgetNBT.getToolValue(this.destructionGadget, GadgetNBT.IntSettings.DOWN.getName()));
        this.sliders.add(this.down);
        this.originalDepth = this.depth.getValueInt();
        this.originalLeft = this.left.getValueInt();
        this.originalRight = this.right.getValueInt();
        this.originalUp = this.up.getValueInt();
        this.originalDown = this.down.getValueInt();
        this.updateSizeString();
        this.updateIsValid();
        this.sliders.forEach(gui -> gui.getComponents().forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }));
    }

    public IncrementalSliderWidget createSlider(int x, int y, MutableComponent prefix, int value) {
        return new IncrementalSliderWidget(x, y, 70, 14, 0.0, 16.0, (Component)prefix.append(": "), value, this::onSliderUpdate);
    }

    public void onSliderUpdate(IncrementalSliderWidget widget) {
        this.updateSizeString();
        this.updateIsValid();
        this.sendPacket();
    }

    private boolean isWithinBounds() {
        int x = this.left.getValueInt() + this.right.getValueInt();
        int y = this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        int dim = 16;
        return x <= 32 && y <= 32 && z <= 16;
    }

    private String getSizeString() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        return String.format("%d x %d x %d", x, y, z);
    }

    private void updateIsValid() {
        this.isValidSize = this.isWithinBounds();
    }

    private void updateSizeString() {
        this.sizeString = this.getSizeString();
    }

    private void sendPacket() {
        if (this.isWithinBounds()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new DestructionRangesPayload(this.left.getValueInt(), this.right.getValueInt(), this.up.getValueInt(), this.down.getValueInt(), this.depth.getValueInt()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.sizeString, this.width / 2, this.height / 2 + 40, this.isValidSize ? 65280 : 0xFF2000);
        if (!this.isValidSize) {
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"buildinggadgets2.screen.destructiontoolarge"), this.width / 2, this.height / 2 + 50, 0xFF2000);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void tick() {
        if (this.keyDown && !InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)KeyBindings.menuSettings.getKey().getValue())) {
            this.onClose();
        }
        super.tick();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.keyDown) {
            return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

