/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.cheese;

import com.pyzpre.createbitterballen.block.cheese.AgedCheeseBlock;
import com.pyzpre.createbitterballen.block.cheese.YoungCheeseBlock;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.pyzpre.createbitterballen.index.ItemRegistry;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import org.jetbrains.annotations.Nullable;

public class WaxedAgedCheeseBlock
extends Block
implements IBlockExtension {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    public static final BooleanProperty WAXED = BooleanProperty.create((String)"waxed");
    private static final VoxelShape SHAPE = WaxedAgedCheeseBlock.makeShape();

    public WaxedAgedCheeseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(2))).setValue((Property)WAXED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        return Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item usedItem = itemStack.getItem();
        if (!world.isClientSide) {
            if (usedItem instanceof AxeItem) {
                if (this.handleDewaxing(world, pos)) {
                    return ItemInteractionResult.SUCCESS;
                }
            } else if ((stack.is(Tags.Items.TOOLS_SHEAR) || stack.is(YoungCheeseBlock.TOOLS_KNIVES)) && this.handleShearing(world, pos, state)) {
                player.swing(hand, true);
                this.playShearingEffect(world, pos);
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean handleDewaxing(Level world, BlockPos pos) {
        BlockState agedCheeseState = (BlockState)((AgedCheeseBlock)((Object)BlockRegistry.AGED_CHEESE.get())).defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(2));
        world.setBlock(pos, agedCheeseState, 3);
        this.playWaxOffEffect(world, pos);
        return true;
    }

    private boolean handleShearing(Level world, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 1 || age == 2) {
            this.dropCheeseProducts(world, pos, age);
            world.removeBlock(pos, false);
            this.playShearingEffect(world, pos);
            return true;
        }
        return false;
    }

    private void playWaxOffEffect(Level world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void dropCheeseProducts(Level world, BlockPos pos, int age) {
        ItemStack dropItem = age == 1 ? new ItemStack((ItemLike)ItemRegistry.YOUNG_CHEESE_WEDGE.get()) : new ItemStack((ItemLike)ItemRegistry.AGED_CHEESE_WEDGE.get());
        RandomSource random = world.random;
        for (int i = 0; i < 4; ++i) {
            double d0 = random.nextFloat() * 0.7f + 0.15f;
            double d1 = (double)(random.nextFloat() * 0.7f + 0.060000002f) + 0.6;
            double d2 = random.nextFloat() * 0.7f + 0.15f;
            ItemStack itemStackCopy = dropItem.copy();
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, itemStackCopy);
            itemEntity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    private void playShearingEffect(Level world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, WAXED});
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        if (!world.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            WaxedAgedCheeseBlock.grantAdvancementCriterion(serverPlayer, "create_bic_bit:cheese", "placed_cheese");
        }
    }

    private static void grantAdvancementCriterion(ServerPlayer player, String advancementID, String criterionKey) {
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        ResourceLocation id = ResourceLocation.parse((String)advancementID);
        Optional<AdvancementHolder> optionalHolder = Optional.ofNullable(player.server.getAdvancements().get(id));
        optionalHolder.ifPresent(holder -> {
            AdvancementProgress progress;
            if (holder.value().criteria().containsKey(criterionKey) && !(progress = playerAdvancements.getOrStartProgress(holder)).isDone()) {
                playerAdvancements.award(holder, criterionKey);
            }
        });
    }
}

