/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.cheese;

import com.pyzpre.createbitterballen.block.cheese.WaxedUnripeCheeseBlock;
import com.pyzpre.createbitterballen.block.cheese.YoungCheeseBlock;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.pyzpre.createbitterballen.index.ItemRegistry;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import org.jetbrains.annotations.Nullable;

public class UnripeCheeseBlock
extends Block
implements IBlockExtension {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final BooleanProperty WAXED = BooleanProperty.create((String)"waxed");
    private static final VoxelShape SHAPE = UnripeCheeseBlock.makeShape();

    public UnripeCheeseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)WAXED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        return Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (random.nextInt(20) == 0) {
            this.age((Level)world, pos, state);
        }
    }

    private void age(Level world, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 1) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            BlockState youngCheeseState = ((YoungCheeseBlock)((Object)BlockRegistry.YOUNG_CHEESE.get())).defaultBlockState();
            world.setBlock(pos, youngCheeseState, 3);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.isClientSide) {
            if (stack.is(Items.HONEYCOMB)) {
                if (this.handleWaxing(world, pos, state, player, stack)) {
                    return ItemInteractionResult.CONSUME;
                }
            } else if ((stack.is(Tags.Items.TOOLS_SHEAR) || stack.is(YoungCheeseBlock.TOOLS_KNIVES)) && this.handleShearing(world, pos, state)) {
                player.swing(hand, true);
                this.playShearingEffect(world, pos);
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean handleWaxing(Level world, BlockPos pos, BlockState state, Player player, ItemStack itemStack) {
        BlockState waxedState = (BlockState)((BlockState)((WaxedUnripeCheeseBlock)((Object)BlockRegistry.WAXED_UNRIPE_CHEESE.get())).defaultBlockState().setValue((Property)WaxedUnripeCheeseBlock.AGE, (Comparable)((Integer)state.getValue((Property)AGE)))).setValue((Property)WaxedUnripeCheeseBlock.WAXED, (Comparable)Boolean.valueOf(true));
        world.setBlock(pos, waxedState, 3);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        this.playWaxOnEffect(world, pos);
        world.scheduleTick(pos, (Block)BlockRegistry.WAXED_UNRIPE_CHEESE.get(), 1);
        return true;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
    }

    private boolean handleShearing(Level world, BlockPos pos, BlockState state) {
        this.dropCheeseProducts(world, pos);
        world.removeBlock(pos, false);
        this.playShearingEffect(world, pos);
        return true;
    }

    private void playWaxOnEffect(Level world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            for (int i = 0; i < 20; ++i) {
                double d0 = serverWorld.random.nextGaussian() * 0.1;
                double d1 = serverWorld.random.nextGaussian() * 0.1;
                double d2 = serverWorld.random.nextGaussian() * 0.1;
                double x = (double)pos.getX() + 0.5 + serverWorld.random.nextGaussian() * 0.5;
                double y = (double)pos.getY() + 0.6;
                double z = (double)pos.getZ() + 0.5 + serverWorld.random.nextGaussian() * 0.5;
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.WAX_ON, x, y, z, 1, d0, d1, d2, 0.0);
            }
        }
    }

    private void dropCheeseProducts(Level world, BlockPos pos) {
        ItemStack dropItem = new ItemStack((ItemLike)ItemRegistry.UNRIPE_CHEESE_WEDGE.get());
        RandomSource random = world.random;
        for (int i = 0; i < 4; ++i) {
            double d0 = random.nextFloat() * 0.7f + 0.15f;
            double d1 = (double)(random.nextFloat() * 0.7f + 0.060000002f) + 0.6;
            double d2 = random.nextFloat() * 0.7f + 0.15f;
            ItemStack itemStackCopy = dropItem.copy();
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, itemStackCopy);
            itemEntity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    private void playShearingEffect(Level world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, WAXED});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        FontHelper.Palette palette = FontHelper.Palette.STANDARD_CREATE;
        tooltip.add((Component)TooltipHelper.holdShift((FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE, (boolean)true));
        if (Screen.hasShiftDown()) {
            MutableComponent part1 = Component.translatable((String)"item.create_bic_bit.cheese.tooltip.part1").withStyle(palette.primary());
            MutableComponent part2 = Component.translatable((String)"item.create_bic_bit.cheese.tooltip.part2").withStyle(palette.highlight());
            MutableComponent part3 = Component.translatable((String)"item.create_bic_bit.cheese.tooltip.part3").withStyle(palette.primary());
            tooltip.add((Component)part1.append((Component)part2).append((Component)part3));
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        if (!world.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            UnripeCheeseBlock.grantAdvancementCriterion(serverPlayer, "create_bic_bit:cheese", "placed_cheese");
        }
    }

    private static void grantAdvancementCriterion(ServerPlayer player, String advancementID, String criterionKey) {
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        ResourceLocation id = ResourceLocation.parse((String)advancementID);
        Optional<AdvancementHolder> optionalHolder = Optional.ofNullable(player.server.getAdvancements().get(id));
        optionalHolder.ifPresent(holder -> {
            AdvancementProgress progress;
            if (holder.value().criteria().containsKey(criterionKey) && !(progress = playerAdvancements.getOrStartProgress(holder)).isDone()) {
                playerAdvancements.award(holder, criterionKey);
            }
        });
    }
}

