/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mezz.itemzoom.client.KeyBindings;
import mezz.itemzoom.client.compat.JeiCompat;
import mezz.itemzoom.client.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class RenderHandler {
    @Nullable
    public static Rect2i rendering = null;
    @Nullable
    private static Rect2i renderedThisFrame = null;
    private final Config config;
    private final Supplier<Boolean> isEnableKeyHeld;

    public RenderHandler(Config config, Supplier<Boolean> isEnableKeyHeld) {
        this.config = config;
        this.isEnableKeyHeld = isEnableKeyHeld;
    }

    public void onScreenDrawn() {
        rendering = renderedThisFrame;
        renderedThisFrame = null;
    }

    public void onItemStackTooltip(GuiGraphics guiGraphics, @Nullable ItemStack itemStack, int x, int y) {
        AbstractContainerScreen containerScreen;
        Rect2i renderArea;
        if (!this.config.isToggledEnabled() && !this.isEnableKeyHeld.get().booleanValue()) {
            return;
        }
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        if (this.config.isJeiOnly() && !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)JeiCompat.getStackUnderMouse())) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Screen currentScreen = minecraft.screen;
        if (currentScreen instanceof AbstractContainerScreen && !(renderArea = this.getRenderingArea(containerScreen = (AbstractContainerScreen)currentScreen, x)).contains(x, y) && this.renderZoomedStack(guiGraphics, itemStack, renderArea, minecraft)) {
            renderedThisFrame = renderArea;
        }
    }

    public Rect2i getRenderingArea(AbstractContainerScreen<?> containerScreen, int mouseX) {
        Minecraft minecraft = containerScreen.getMinecraft();
        Window window = minecraft.getWindow();
        int guiRight = containerScreen.getGuiLeft() + containerScreen.getXSize();
        int spaceOnLeft = this.getSpaceOnLeft(containerScreen);
        int spaceOnRight = window.getGuiScaledWidth() - guiRight;
        boolean renderLeft = mouseX < containerScreen.getGuiLeft() ? false : (mouseX > guiRight ? true : (double)spaceOnLeft * 1.1 >= (double)spaceOnRight);
        int y = containerScreen.getGuiTop();
        int height = containerScreen.getYSize();
        if (renderLeft) {
            return new Rect2i(0, y, spaceOnLeft, height);
        }
        return new Rect2i(guiRight, y, spaceOnRight, height);
    }

    private int getSpaceOnLeft(AbstractContainerScreen<?> containerScreen) {
        RecipeUpdateListener recipeListener;
        RecipeBookComponent guiRecipeBook;
        if (containerScreen instanceof RecipeUpdateListener && (guiRecipeBook = (recipeListener = (RecipeUpdateListener)containerScreen).getRecipeBookComponent()).isVisible()) {
            return guiRecipeBook.tabButtons.stream().findAny().map(AbstractWidget::getX).orElse((guiRecipeBook.width - 147) / 2 - guiRecipeBook.xOffset);
        }
        return containerScreen.getGuiLeft();
    }

    private boolean renderZoomedStack(GuiGraphics guiGraphics, ItemStack itemStack, Rect2i availableArea, Minecraft minecraft) {
        int availableAreaX = availableArea.getX();
        int availableAreaY = availableArea.getY();
        int availableAreaWidth = availableArea.getWidth();
        int availableAreaHeight = availableArea.getHeight();
        float scale = (float)this.config.getZoomAmount() / 100.0f * (float)availableAreaWidth / 17.0f;
        if (scale <= 2.0f) {
            return false;
        }
        float renderWidth = scale * 16.0f;
        float renderHeight = scale * 16.0f;
        float xPosition = (float)availableAreaX + ((float)availableAreaWidth - renderWidth) / 2.0f;
        float yPosition = (float)availableAreaY + ((float)availableAreaHeight - renderHeight) / 2.0f;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(xPosition, yPosition, 232.0f);
        poseStack.scale(scale, scale, scale);
        guiGraphics.renderItem(itemStack, 0, 0);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        this.renderItemOverlayIntoGUI(guiGraphics, itemStack);
        poseStack.popPose();
        RenderSystem.applyModelViewMatrix();
        if (this.config.showHelpText()) {
            int y = availableAreaY + (availableAreaHeight + Math.round(19.0f * scale)) / 2;
            String modName = "Item Zoom";
            Font nameFont = RenderHandler.getFont(minecraft, itemStack, IClientItemExtensions.FontContext.SELECTED_ITEM_NAME);
            int stringWidth = nameFont.width(modName);
            if (stringWidth < availableAreaWidth) {
                int x = availableAreaX + (availableAreaWidth - stringWidth) / 2;
                guiGraphics.drawString(nameFont, modName, x, y, 0x404040, false);
                Objects.requireNonNull(nameFont);
                y += 9;
            }
            if (this.config.isToggledEnabled()) {
                KeyBindings keyBindings = KeyBindings.getInstance();
                Font minecraftFont = minecraft.font;
                Component displayName = keyBindings.toggle.getTranslatedKeyMessage();
                String toggleText = displayName.getString();
                stringWidth = minecraftFont.width(toggleText);
                if (stringWidth < availableAreaWidth) {
                    int x = availableAreaX + (availableAreaWidth - stringWidth) / 2;
                    guiGraphics.drawString(minecraftFont, toggleText, x, y, 0x404040, false);
                }
            }
        }
        return true;
    }

    private static Font getFont(Minecraft minecraft, ItemStack itemStack, IClientItemExtensions.FontContext context) {
        IClientItemExtensions renderProperties = IClientItemExtensions.of((ItemStack)itemStack);
        Font fontRenderer = renderProperties.getFont(itemStack, context);
        if (fontRenderer == null) {
            fontRenderer = minecraft.font;
        }
        return fontRenderer;
    }

    public void renderItemOverlayIntoGUI(GuiGraphics guiGraphics, ItemStack itemStack) {
        LocalPlayer localplayer;
        if (itemStack.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        if (this.config.showStackSize() && itemStack.getCount() != 1) {
            String countString = String.valueOf(itemStack.getCount());
            Font itemCountFont = RenderHandler.getFont(minecraft, itemStack, IClientItemExtensions.FontContext.ITEM_COUNT);
            poseStack.translate(0.0f, 0.0f, 200.0f);
            RenderBuffers renderBuffers = minecraft.renderBuffers();
            MultiBufferSource.BufferSource bufferSource = renderBuffers.bufferSource();
            itemCountFont.drawInBatch(countString, 17.0f - (float)itemCountFont.width(countString), 9.0f, 0xFFFFFF, true, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            bufferSource.endBatch();
        }
        if (this.config.showDurabilityBar() && itemStack.isBarVisible()) {
            RenderSystem.disableDepthTest();
            int k = itemStack.getBarWidth();
            int l = itemStack.getBarColor();
            guiGraphics.fill(2, 13, 15, 15, -16777215);
            guiGraphics.fill(2, 13, 2 + k, 14, l | 0xFF000001);
            RenderSystem.enableDepthTest();
        }
        if (this.config.showCooldown() && (localplayer = minecraft.player) != null) {
            ItemCooldowns cooldowns = localplayer.getCooldowns();
            float partialTicks = minecraft.getTimer().getGameTimeDeltaPartialTick(true);
            float cooldownPercent = cooldowns.getCooldownPercent(itemStack.getItem(), partialTicks);
            if (cooldownPercent > 0.0f) {
                RenderSystem.disableDepthTest();
                int i1 = Mth.floor((float)(16.0f * (1.0f - cooldownPercent)));
                int j1 = i1 + Mth.ceil((float)(16.0f * cooldownPercent));
                guiGraphics.fill(0, i1, 16, j1, Integer.MAX_VALUE);
                RenderSystem.enableDepthTest();
            }
        }
        poseStack.popPose();
    }
}

