/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_circuit_breaker.client.gui.screen;

import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import dev.tr3ymix.cfm_circuit_breaker.Config;
import dev.tr3ymix.cfm_circuit_breaker.inventory.CircuitBreakerMenu;
import dev.tr3ymix.cfm_circuit_breaker.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class CircuitBreakerScreen
extends AbstractContainerScreen<CircuitBreakerMenu> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/circuit_breaker.png");
    protected OnOffSlider slider;

    public CircuitBreakerScreen(CircuitBreakerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void init() {
        super.init();
        this.slider = (OnOffSlider)this.addRenderableWidget((GuiEventListener)new OnOffSlider(this.leftPos + this.imageWidth - 22 - 6, this.topPos + 5, (Component)Utils.translation("gui", "generator_toggle", new Object[0]), btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((CircuitBreakerMenu)this.menu).isEnabled());
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((CircuitBreakerMenu)this.menu).getEnergy() > 0) {
            int energyLevel = (int)(60.0f * ((float)((CircuitBreakerMenu)this.menu).getEnergy() / (float)((CircuitBreakerMenu)this.menu).getMaxEnergy()));
            graphics.blit(TEXTURE, this.leftPos + 26, this.topPos + 17 + 60 - energyLevel, 176, 60 - energyLevel, 6, energyLevel);
        }
        Status status = this.getStatus();
        graphics.blit(IconButton.ICON_TEXTURES, this.leftPos + 66, this.topPos + 29, (float)status.iconU, (float)status.iconV, 10, 10, 64, 64);
        graphics.blit(IconButton.ICON_TEXTURES, this.leftPos + 66, this.topPos + 46, 0.0f, 10.0f, 10, 10, 64, 64);
        if (ScreenHelper.isMouseWithinBounds((double)mouseX, (double)mouseY, (int)(this.leftPos + 26), (int)(this.topPos + 17), (int)6, (int)60)) {
            this.setTooltipForNextRenderPass((Component)Utils.translation("gui", "progress", ((CircuitBreakerMenu)this.menu).getEnergy(), ((CircuitBreakerMenu)this.menu).getMaxEnergy()));
        }
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        Status status = this.getStatus();
        graphics.drawString(this.font, status.label, 80, 30, status.textColour, true);
        Pair<Component, Integer> pair = this.getNodeCount();
        graphics.drawString(this.font, (Component)pair.left(), 80, 47, ((Integer)pair.right()).intValue(), true);
    }

    private Pair<Component, Integer> getNodeCount() {
        int nodeCount = ((CircuitBreakerMenu)this.menu).getNodeCount();
        int maxNodeCount = Config.maximumNodesInCircuitBreakerNetwork;
        MutableComponent label = Utils.translation("gui", "node_count", nodeCount, maxNodeCount);
        int textColour = nodeCount > maxNodeCount ? -3983818 : -1;
        return Pair.of((Object)label, (Object)textColour);
    }

    private Status getStatus() {
        if (((CircuitBreakerMenu)this.menu).isOverloaded()) {
            return Status.OVERLOADED;
        }
        if (((CircuitBreakerMenu)this.menu).isEnabled()) {
            if (((CircuitBreakerMenu)this.menu).isPowered()) {
                return Status.ONLINE;
            }
            if (((CircuitBreakerMenu)this.menu).getEnergy() == 0) {
                return Status.NO_ENERGY;
            }
        }
        return Status.OFFLINE;
    }

    private static enum Status {
        ONLINE(-8799453, 50, 0, (Component)Utils.translation("gui", "status.online", new Object[0])),
        OFFLINE(-3983818, 40, 0, (Component)Utils.translation("gui", "status.offline", new Object[0])),
        OVERLOADED(-2711764, 30, 0, (Component)Utils.translation("gui", "status.overloaded", new Object[0])),
        NO_ENERGY(-2711764, 20, 20, (Component)Utils.translation("gui", "status.energy", new Object[0]));

        private final int textColour;
        private final int iconU;
        private final int iconV;
        private final Component label;

        private Status(int textColour, int iconU, int iconV, Component label) {
            this.textColour = textColour;
            this.iconU = iconU;
            this.iconV = iconV;
            this.label = label;
        }
    }
}

