/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_circuit_breaker.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import dev.tr3ymix.cfm_circuit_breaker.blockentity.CircuitBreakerBlockEntity;
import dev.tr3ymix.cfm_circuit_breaker.util.voxel.CircuitBreakerBlockShapes;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CircuitBreakerBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    public CircuitBreakerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> Shapes.block())));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return CircuitBreakerBlockShapes.getShape((Direction)state.getValue((Property)DIRECTION));
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult result) {
        BlockEntity entity;
        super.useWithoutItem(state, level, pos, player, result);
        if (!level.isClientSide() && (entity = level.getBlockEntity(pos)) instanceof CircuitBreakerBlockEntity) {
            CircuitBreakerBlockEntity circuitManager = (CircuitBreakerBlockEntity)entity;
            player.openMenu((MenuProvider)circuitManager);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{OPEN});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CircuitBreakerBlockEntity(pos, state);
    }

    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_STONE_TOOL);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction faceDirection = context.getClickedFace();
        if (faceDirection == Direction.DOWN || faceDirection == Direction.UP) {
            return null;
        }
        Direction direction = context.getHorizontalDirection();
        return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)direction);
    }
}

