/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_circuit_breaker;

import dev.tr3ymix.cfm_circuit_breaker.Config;
import dev.tr3ymix.cfm_circuit_breaker.blockentity.CircuitBreakerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="cfm_circuit_breaker")
public class NeoForgeEvents {
    @SubscribeEvent
    public static void onLightningStrike(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LightningBolt) {
            LightningBolt bolt = (LightningBolt)entity;
            if (!entity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)entity.level();
                BlockPos lightningPos = bolt.blockPosition();
                int radius = Config.lightningStrikeOutageRadius;
                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)lightningPos.offset(-radius, -radius, -radius), (BlockPos)lightningPos.offset(radius, radius, radius))) {
                    BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
                    if (!(blockEntity instanceof CircuitBreakerBlockEntity)) continue;
                    CircuitBreakerBlockEntity circuitBreaker = (CircuitBreakerBlockEntity)blockEntity;
                    circuitBreaker.disableThis();
                    circuitBreaker.setChanged();
                }
            }
        }
    }
}

