/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_circuit_breaker;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="cfm_circuit_breaker", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue MAXIMUM_NODES_IN_CIRCUIT_BREAKER_NETWORK = BUILDER.comment("The maximum amount of nodes in a network that can be powered by the circuit breaker.").defineInRange("maximumNodesInCircuitBreakerNetwork", 128, 1, 1024);
    private static final ModConfigSpec.IntValue LIGHTNING_STRIKE_OUTAGE_RADIUS = BUILDER.comment("The radius (in blocks) within which the circuit breaker is disabled when a lightning bolt occurs.").defineInRange("lightningStrikeOutageRadius", 30, 15, 1024);
    static final ModConfigSpec CONFIG_SPEC = BUILDER.build();
    public static int maximumNodesInCircuitBreakerNetwork;
    public static int lightningStrikeOutageRadius;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        maximumNodesInCircuitBreakerNetwork = (Integer)MAXIMUM_NODES_IN_CIRCUIT_BREAKER_NETWORK.get();
        lightningStrikeOutageRadius = (Integer)LIGHTNING_STRIKE_OUTAGE_RADIUS.get();
    }
}

