/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.BackpackMainSettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common.MountedBackpackContext;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageSettingsContainerMenuBase;

public class MountedBackpackSettingsContainerMenu
extends MountedStorageSettingsContainerMenuBase {
    private final MountedBackpackContext context;

    protected MountedBackpackSettingsContainerMenu(int windowId, Player player, MountedBackpackContext context) {
        this(ModContent.MOUNTED_BACKPACK_SETTINGS_CONTAINER_TYPE.get(), windowId, player, context);
    }

    protected MountedBackpackSettingsContainerMenu(MenuType<?> menuType, int windowId, Player player, MountedBackpackContext context) {
        super(menuType, windowId, player, context.getBackpackWrapper(player), context.getContraptionEntityId(), context.getLocalPos());
        this.context = context;
    }

    protected CompoundTag getSettingsTag(CompoundTag contents) {
        return contents.getCompound("settings");
    }

    public static MountedBackpackSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MountedBackpackSettingsContainerMenu(windowId, playerInventory.player, MountedBackpackContext.fromBuffer(buffer));
    }

    public MountedBackpackContext getContext() {
        return this.context;
    }

    protected CustomPacketPayload instantiateSettingsPayload(UUID uuid, CompoundTag settingsContents) {
        return new BackpackContentsPayload(uuid, settingsContents);
    }

    protected void updateFromContents(UUID uuid) {
        BackpackStorage storage = BackpackStorage.get();
        if (storage.removeUpdatedBackpackSettingsFlag(uuid)) {
            this.storageWrapper.getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents(uuid));
        }
    }

    static {
        SettingsContainerMenu.addFactory((String)"backpackGlobal", BackpackMainSettingsContainer::new);
    }
}

