/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.neoforge.datagen.server;

import com.kekecreations.arts_and_crafts.common.block.ACBedBlock;
import com.kekecreations.arts_and_crafts.common.util.PietraforteColour;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ArtsAndCraftsBlockLootSubProvider
extends BlockLootSubProvider {
    private static final Set<Item> EXPLOSION_RESISTANT = Set.of();
    HashSet<Block> knownBlocks = new HashSet();

    public ArtsAndCraftsBlockLootSubProvider(HolderLookup.Provider provider) {
        super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    public void generate() {
        this.terracottaShingles();
        this.chalk();
        this.soapstone();
        this.cork();
        this.plaster();
        this.gypsum();
        this.bleached();
        this.flowerPots();
        this.hangingFlowerPots();
        this.chalkDust();
        this.decoratedPots();
        this.mudBricks();
        this.dropOther(ACBlocks.LOTUS_FLOWER.get(), (ItemLike)ACItems.LOTUS_PISTILS.get());
        this.pietraforte();
    }

    public void dropSelf(Block block) {
        this.knownBlocks.add(block);
        this.dropOther(block, (ItemLike)block);
    }

    protected void add(Block block, LootTable.Builder builder) {
        this.knownBlocks.add(block);
        this.map.put(block.getLootTable(), builder);
    }

    private void hangingFlowerPots() {
    }

    private void pietraforte() {
        for (PietraforteColour colour : PietraforteColour.values()) {
            this.dropSelf(ACBlocks.getCobbledPietraforte(colour));
            this.dropSelf((Block)ACBlocks.getCobbledPietraforteStairs(colour));
            this.add((Block)ACBlocks.getCobbledPietraforteSlab(colour), this.createSlabItemTable((Block)ACBlocks.getCobbledPietraforteSlab(colour)));
            this.dropSelf((Block)ACBlocks.getCobbledPietraforteWall(colour));
            this.dropOther(ACBlocks.getPietraforte(colour), (ItemLike)ACBlocks.getCobbledPietraforte(colour));
            this.dropSelf((Block)ACBlocks.getPietraforteStairs(colour));
            this.add((Block)ACBlocks.getPietraforteSlab(colour), this.createSlabItemTable((Block)ACBlocks.getPietraforteSlab(colour)));
            this.dropSelf((Block)ACBlocks.getPietraforteWall(colour));
            this.dropSelf(ACBlocks.getChiseledPietraforte(colour));
            this.dropSelf(ACBlocks.getPietraforteBricks(colour));
            this.dropSelf((Block)ACBlocks.getPietraforteBrickStairs(colour));
            this.add((Block)ACBlocks.getPietraforteBrickSlab(colour), this.createSlabItemTable((Block)ACBlocks.getPietraforteBrickSlab(colour)));
            this.dropSelf((Block)ACBlocks.getPietraforteBrickWall(colour));
            this.dropSelf((Block)ACBlocks.getPietrafortePillar(colour));
            this.dropSelf(ACBlocks.getSmoothPietraforte(colour));
            this.dropSelf((Block)ACBlocks.getSmoothPietraforteStairs(colour));
            this.add((Block)ACBlocks.getSmoothPietraforteSlab(colour), this.createSlabItemTable((Block)ACBlocks.getSmoothPietraforteSlab(colour)));
            this.dropSelf((Block)ACBlocks.getSmoothPietraforteWall(colour));
            this.dropSelf(ACBlocks.getCutPietraforte(colour));
            this.dropSelf((Block)ACBlocks.getCutPietraforteStairs(colour));
            this.add((Block)ACBlocks.getCutPietraforteSlab(colour), this.createSlabItemTable((Block)ACBlocks.getCutPietraforteSlab(colour)));
            this.dropSelf((Block)ACBlocks.getCutPietraforteWall(colour));
        }
    }

    private void bleached() {
        this.dropSelf(ACBlocks.BLEACHED_WOOL.get());
        this.dropSelf(ACBlocks.BLEACHED_CARPET.get());
        this.dropSelf(ACBlocks.GLAZED_TERRACOTTA.get());
        this.dropSelf(ACBlocks.BLEACHED_CONCRETE_POWDER.get());
        this.dropSelf(ACBlocks.BLEACHED_CONCRETE.get());
        this.add(ACBlocks.BLEACHED_BED.get(), this.createSinglePropConditionTable(ACBlocks.BLEACHED_BED.get(), (Property)ACBedBlock.PART, (Comparable)BedPart.HEAD));
    }

    private void decoratedPots() {
        for (DyeColor colours : DyeColor.values()) {
            this.add(ACBlocks.getDyedDecoratedPot(colours.getId()), this.createDecoratedPotTable(ACBlocks.getDyedDecoratedPot(colours.getId())));
        }
    }

    private void mudBricks() {
        for (DyeColor colours : DyeColor.values()) {
            this.dropSelf(ACBlocks.getDyedMudBricks(colours.getId()));
            this.dropSelf(ACBlocks.getDyedMudBrickStairs(colours.getId()));
            this.add(ACBlocks.getDyedMudBrickSlab(colours.getId()), this.createSlabItemTable(ACBlocks.getDyedMudBrickSlab(colours.getId())));
            this.dropSelf(ACBlocks.getDyedMudBrickWall(colours.getId()));
        }
    }

    private void terracottaShingles() {
        for (DyeColor colours : DyeColor.values()) {
            this.dropSelf(ACBlocks.getDyedTerracottaShingles(colours.getId()));
            this.dropSelf(ACBlocks.getDyedTerracottaShingleStairs(colours.getId()));
            this.add(ACBlocks.getDyedTerracottaShingleSlab(colours.getId()), this.createSlabItemTable(ACBlocks.getDyedTerracottaShingleSlab(colours.getId())));
            this.dropSelf(ACBlocks.getDyedTerracottaShingleWall(colours.getId()));
        }
        this.dropSelf(ACBlocks.TERRACOTTA_SHINGLES.get());
        this.add((Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get()));
        this.dropSelf((Block)ACBlocks.TERRACOTTA_SHINGLE_WALL.get());
        this.dropSelf((Block)ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get());
    }

    private void chalk() {
        for (DyeColor colours : DyeColor.values()) {
            this.dropSelf(ACBlocks.getChalk(colours.getId()));
        }
        this.dropSelf(ACBlocks.BLEACHED_CHALK.get());
    }

    private void soapstone() {
        for (DyeColor colours : DyeColor.values()) {
            this.dropSelf(ACBlocks.getDyedSoapstone(colours.getId()));
            this.dropSelf(ACBlocks.getDyedSoapstoneStairs(colours.getId()));
            this.add(ACBlocks.getDyedSoapstoneSlab(colours.getId()), this.createSlabItemTable(ACBlocks.getDyedSoapstoneSlab(colours.getId())));
            this.dropSelf(ACBlocks.getDyedSoapstoneWall(colours.getId()));
            this.dropSelf(ACBlocks.getDyedSoapstoneBricks(colours.getId()));
            this.dropSelf(ACBlocks.getDyedSoapstoneBrickStairs(colours.getId()));
            this.add(ACBlocks.getDyedSoapstoneBrickSlab(colours.getId()), this.createSlabItemTable(ACBlocks.getDyedSoapstoneBrickSlab(colours.getId())));
            this.dropSelf(ACBlocks.getDyedSoapstoneBrickWall(colours.getId()));
            this.dropSelf(ACBlocks.getDyedPolishedSoapstone(colours.getId()));
            this.dropSelf(ACBlocks.getDyedPolishedSoapstoneStairs(colours.getId()));
            this.add(ACBlocks.getDyedPolishedSoapstoneSlab(colours.getId()), this.createSlabItemTable(ACBlocks.getDyedPolishedSoapstoneSlab(colours.getId())));
            this.dropSelf(ACBlocks.getDyedPolishedSoapstoneWall(colours.getId()));
        }
        this.dropSelf(ACBlocks.SOAPSTONE.get());
        this.add((Block)ACBlocks.SOAPSTONE_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.SOAPSTONE_SLAB.get()));
        this.dropSelf((Block)ACBlocks.SOAPSTONE_WALL.get());
        this.dropSelf((Block)ACBlocks.SOAPSTONE_STAIRS.get());
        this.dropSelf(ACBlocks.SOAPSTONE_BRICKS.get());
        this.add((Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get()));
        this.dropSelf((Block)ACBlocks.SOAPSTONE_BRICK_WALL.get());
        this.dropSelf((Block)ACBlocks.SOAPSTONE_BRICK_STAIRS.get());
        this.dropSelf(ACBlocks.POLISHED_SOAPSTONE.get());
        this.add((Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get()));
        this.dropSelf((Block)ACBlocks.POLISHED_SOAPSTONE_WALL.get());
        this.dropSelf((Block)ACBlocks.POLISHED_SOAPSTONE_STAIRS.get());
    }

    private void gypsum() {
        this.dropSelf(ACBlocks.GYPSUM.get());
        this.add((Block)ACBlocks.GYPSUM_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.GYPSUM_SLAB.get()));
        this.dropSelf((Block)ACBlocks.GYPSUM_WALL.get());
        this.dropSelf((Block)ACBlocks.GYPSUM_STAIRS.get());
        this.dropSelf(ACBlocks.GYPSUM_BRICKS.get());
        this.add((Block)ACBlocks.GYPSUM_BRICK_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.GYPSUM_BRICK_SLAB.get()));
        this.dropSelf((Block)ACBlocks.GYPSUM_BRICK_WALL.get());
        this.dropSelf((Block)ACBlocks.GYPSUM_BRICK_STAIRS.get());
        this.dropSelf(ACBlocks.POLISHED_GYPSUM.get());
        this.add((Block)ACBlocks.POLISHED_GYPSUM_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.POLISHED_GYPSUM_SLAB.get()));
        this.dropSelf((Block)ACBlocks.POLISHED_GYPSUM_WALL.get());
        this.dropSelf((Block)ACBlocks.POLISHED_GYPSUM_STAIRS.get());
    }

    private void cork() {
        this.add((Block)ACBlocks.CORK_LEAVES.get(), block -> this.createLeavesDrops((Block)ACBlocks.CORK_LEAVES.get(), (Block)ACBlocks.CORK_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(ACBlocks.CORK.get());
        this.dropSelf(ACBlocks.SMOOTH_CORK.get());
        this.dropSelf((Block)ACBlocks.CORK_LOG.get());
        this.dropSelf((Block)ACBlocks.STRIPPED_CORK_LOG.get());
        this.dropSelf((Block)ACBlocks.CORK_WOOD.get());
        this.dropSelf((Block)ACBlocks.STRIPPED_CORK_WOOD.get());
        this.dropSelf((Block)ACBlocks.CORK_PLANKS.get());
        this.dropSelf((Block)ACBlocks.CORK_STAIRS.get());
        this.add((Block)ACBlocks.CORK_SLAB.get(), this.createSlabItemTable((Block)ACBlocks.CORK_SLAB.get()));
        this.dropSelf((Block)ACBlocks.CORK_FENCE.get());
        this.dropSelf((Block)ACBlocks.CORK_FENCE_GATE.get());
        this.dropSelf((Block)ACBlocks.CORK_BUTTON.get());
        this.dropSelf((Block)ACBlocks.CORK_PRESSURE_PLATE.get());
        this.add((Block)ACBlocks.CORK_DOOR.get(), block -> this.createDoorTable((Block)ACBlocks.CORK_DOOR.get()));
        this.dropSelf((Block)ACBlocks.CORK_TRAPDOOR.get());
        this.dropSelf((Block)ACBlocks.CORK_SIGN.get());
        this.dropSelf((Block)ACBlocks.CORK_HANGING_SIGN.get());
        this.dropSelf((Block)ACBlocks.CORK_SAPLING.get());
    }

    private void plaster() {
        this.dropSelf((Block)ACBlocks.PLASTER.get());
        for (DyeColor colours : DyeColor.values()) {
            this.dropSelf(ACBlocks.getDyedPlaster(colours.getId()));
        }
    }

    private void chalkDust() {
        for (DyeColor colours : DyeColor.values()) {
            this.add(ACBlocks.getChalkDust(colours.getId()), ArtsAndCraftsBlockLootSubProvider.noDrop());
        }
        this.add(ACBlocks.BLEACHED_CHALK_DUST.get(), ArtsAndCraftsBlockLootSubProvider.noDrop());
    }

    private void flowerPots() {
        this.add((Block)ACBlocks.POTTED_CORK_SAPLING.get(), block -> this.createPotFlowerItemTable((ItemLike)ACBlocks.CORK_SAPLING.get()));
        for (DyeColor colours : DyeColor.values()) {
            this.dropSelf(ACBlocks.getDyedFlowerPot(colours.getId()));
            this.add(ACBlocks.getDyedPottedCorkSapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)ACBlocks.CORK_SAPLING.get()));
            this.add(ACBlocks.getDyedPottedOakSapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.OAK_SAPLING));
            this.add(ACBlocks.getDyedPottedCrimsonFungus(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.CRIMSON_FUNGUS));
            this.add(ACBlocks.getDyedPottedCrimsonRoots(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.CRIMSON_ROOTS));
            this.add(ACBlocks.getDyedPottedWarpedFungus(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.WARPED_FUNGUS));
            this.add(ACBlocks.getDyedPottedWarpedRoots(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.WARPED_ROOTS));
            this.add(ACBlocks.getDyedPottedSpruceSapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.SPRUCE_SAPLING));
            this.add(ACBlocks.getDyedPottedBirchSapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.BIRCH_SAPLING));
            this.add(ACBlocks.getDyedPottedJungleSapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.JUNGLE_SAPLING));
            this.add(ACBlocks.getDyedPottedAcaciaSapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.ACACIA_SAPLING));
            this.add(ACBlocks.getDyedPottedCherrySapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.CHERRY_SAPLING));
            this.add(ACBlocks.getDyedPottedDarkOakSapling(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.DARK_OAK_SAPLING));
            this.add(ACBlocks.getDyedPottedMangrovePropagule(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.MANGROVE_PROPAGULE));
            this.add(ACBlocks.getDyedPottedFern(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.FERN));
            this.add(ACBlocks.getDyedPottedDandelion(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.DANDELION));
            this.add(ACBlocks.getDyedPottedPoppy(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.POPPY));
            this.add(ACBlocks.getDyedPottedBlueOrchid(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.BLUE_ORCHID));
            this.add(ACBlocks.getDyedPottedAllium(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.ALLIUM));
            this.add(ACBlocks.getDyedPottedAzureBluet(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.AZURE_BLUET));
            this.add(ACBlocks.getDyedPottedRedTulip(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.RED_TULIP));
            this.add(ACBlocks.getDyedPottedOrangeTulip(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.ORANGE_TULIP));
            this.add(ACBlocks.getDyedPottedWhiteTulip(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.WHITE_TULIP));
            this.add(ACBlocks.getDyedPottedPinkTulip(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.PINK_TULIP));
            this.add(ACBlocks.getDyedPottedOxeyeDaisy(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.OXEYE_DAISY));
            this.add(ACBlocks.getDyedPottedCornflower(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.CORNFLOWER));
            this.add(ACBlocks.getDyedPottedLilyOfTheValley(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.LILY_OF_THE_VALLEY));
            this.add(ACBlocks.getDyedPottedWitherRose(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.WITHER_ROSE));
            this.add(ACBlocks.getDyedPottedRedMushroom(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.RED_MUSHROOM));
            this.add(ACBlocks.getDyedPottedBrownMushroom(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.BROWN_MUSHROOM));
            this.add(ACBlocks.getDyedPottedDeadBush(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.DEAD_BUSH));
            this.add(ACBlocks.getDyedPottedCactus(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.CACTUS));
            this.add(ACBlocks.getDyedPottedBamboo(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.BAMBOO));
            this.add(ACBlocks.getDyedPottedAzalea(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.AZALEA));
            this.add(ACBlocks.getDyedPottedFloweringAzalea(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.FLOWERING_AZALEA));
            this.add(ACBlocks.getDyedPottedTorchFlower(colours), block -> this.createDyedPotFlowerItemTable(colours, (ItemLike)Blocks.TORCHFLOWER));
        }
    }

    protected LootTable.Builder createDyedPotFlowerItemTable(DyeColor dyeColor, ItemLike p_249395_) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)ACBlocks.getDyedFlowerPot(dyeColor.getId()), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ACBlocks.getDyedFlowerPot(dyeColor.getId()))))).withPool((LootPool.Builder)this.applyExplosionCondition(p_249395_, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)p_249395_))));
    }

    private LootTable.Builder createDecoratedPotTable(Block $$0x) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)DynamicLoot.dynamicEntry((ResourceLocation)DecoratedPotBlock.SHERDS_DYNAMIC_DROP_ID).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)$$0x).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DecoratedPotBlock.CRACKED, true)))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)$$0x).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.POT_DECORATIONS)))));
    }

    public LootTable.Builder createTwoItemTable(ItemLike p_251912_, ItemLike itemLike2) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition(p_251912_, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)p_251912_)))).withPool((LootPool.Builder)this.applyExplosionCondition(p_251912_, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike2))));
    }
}

