/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.item;

import com.kekecreations.arts_and_crafts.common.entity.ACBedBlockEntity;
import com.kekecreations.arts_and_crafts.common.entity.DyedDecoratedPotBlockEntity;
import com.kekecreations.arts_and_crafts.common.util.PaintbrushUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;

public class PaintbrushItem
extends Item {
    public PaintbrushItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Block finalBlock;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        BlockState blockState = level.getBlockState(pos);
        InteractionHand hand = context.getHand();
        BlockEntity blockEntity = context.getLevel().getBlockEntity(pos);
        if (!level.isClientSide() && (finalBlock = PaintbrushUtils.getFinalBlock(level.registryAccess(), blockState, itemStack)) != null && finalBlock != blockState.getBlock() && finalBlock.isEnabled(finalBlock.requiredFeatures())) {
            if (blockEntity instanceof DyedDecoratedPotBlockEntity) {
                DyedDecoratedPotBlockEntity dyedDecoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)blockEntity;
                ItemStack potItemStack = dyedDecoratedPotBlockEntity.getTheItem().copyAndClear();
                PotDecorations oldDecorations = dyedDecoratedPotBlockEntity.getDecorations();
                PaintbrushUtils.paintBlock(level, finalBlock.defaultBlockState(), pos, player, itemStack, hand);
                PaintbrushUtils.setPotDecorations(level, pos, oldDecorations);
                BlockEntity newBlockEntity = level.getBlockEntity(pos);
                if (newBlockEntity instanceof DyedDecoratedPotBlockEntity) {
                    DyedDecoratedPotBlockEntity newDecoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)newBlockEntity;
                    newDecoratedPotBlockEntity.setTheItem(potItemStack);
                } else if (newBlockEntity instanceof DecoratedPotBlockEntity) {
                    DecoratedPotBlockEntity newDecoratedPotBlockEntity = (DecoratedPotBlockEntity)newBlockEntity;
                    newDecoratedPotBlockEntity.setTheItem(potItemStack);
                }
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof DecoratedPotBlockEntity) {
                DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)blockEntity;
                ItemStack potItemStack = decoratedPotBlockEntity.getTheItem().copyAndClear();
                PotDecorations oldDecorations = decoratedPotBlockEntity.getDecorations();
                PaintbrushUtils.paintBlock(level, finalBlock.defaultBlockState(), pos, player, itemStack, hand);
                PaintbrushUtils.setPotDecorations(level, pos, oldDecorations);
                BlockEntity newBlockEntity = level.getBlockEntity(pos);
                if (newBlockEntity instanceof DyedDecoratedPotBlockEntity) {
                    DyedDecoratedPotBlockEntity newDecoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)newBlockEntity;
                    newDecoratedPotBlockEntity.setTheItem(potItemStack);
                } else if (newBlockEntity instanceof DecoratedPotBlockEntity) {
                    DecoratedPotBlockEntity newDecoratedPotBlockEntity = (DecoratedPotBlockEntity)newBlockEntity;
                    newDecoratedPotBlockEntity.setTheItem(potItemStack);
                }
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    itemList.add(container.getItem(i));
                    container.setItem(i, ItemStack.EMPTY);
                }
                PaintbrushUtils.paintBlock(level, finalBlock.defaultBlockState(), pos, player, itemStack, hand);
                BlockEntity newBlockEntity = level.getBlockEntity(pos);
                if (newBlockEntity instanceof BaseContainerBlockEntity) {
                    BaseContainerBlockEntity newContainer = (BaseContainerBlockEntity)newBlockEntity;
                    for (int i = 0; i < newContainer.getContainerSize(); ++i) {
                        newContainer.setItem(i, (ItemStack)itemList.get(i));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof BedBlockEntity || blockEntity instanceof ACBedBlockEntity) {
                PaintbrushUtils.paintBed(level, finalBlock.defaultBlockState(), pos, player, itemStack, hand);
                return InteractionResult.SUCCESS;
            }
            PaintbrushUtils.paintBlock(level, finalBlock.defaultBlockState(), pos, player, itemStack, hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

