/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.item;

import com.kekecreations.arts_and_crafts.common.block.ChalkDustBlock;
import com.kekecreations.arts_and_crafts.common.util.ACProperties;
import com.kekecreations.arts_and_crafts.common.util.ChalkUtils;
import com.kekecreations.arts_and_crafts.core.platform.Services;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChalkStickItem
extends Item {
    private final Integer dyeColor;

    public ChalkStickItem(Integer dyeColor, Item.Properties properties) {
        super(properties.component(ACDataComponents.CHALK_PATTERN.get(), (Object)0));
        this.dyeColor = dyeColor;
    }

    public int getDyeColor() {
        return this.dyeColor;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext tooltipContext, @NotNull List<Component> toolTipComponents, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, tooltipContext, toolTipComponents, flag);
        if (!itemStack.has(ACDataComponents.CHALK_PATTERN.get())) {
            return;
        }
        toolTipComponents.add((Component)Component.translatable((String)("tooltip.arts_and_crafts.chalk_pattern_" + String.valueOf(itemStack.get(ACDataComponents.CHALK_PATTERN.get())))).withStyle(ChatFormatting.GRAY));
    }

    public boolean isEnabled(FeatureFlagSet $$0) {
        return Services.CONFIG.areChalkSticksEnabled();
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Player player = useOnContext.getPlayer();
        BlockPos blockPos = useOnContext.getClickedPos();
        Level level = useOnContext.getLevel();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        RandomSource random = level.getRandom();
        Vec3 clickLocation = useOnContext.getClickLocation();
        ItemStack itemStack = useOnContext.getItemInHand();
        if (level.isClientSide() && block instanceof ChalkDustBlock) {
            ChalkDustBlock chalkDustBlock = (ChalkDustBlock)block;
            if (player != null) {
                if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ChalkStickItem && !(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ChalkStickItem)) {
                    if (chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                        ChalkUtils.spawnChalkParticle(level, clickLocation.x(), clickLocation.y() + 0.2, clickLocation.z(), this.getDyeColor());
                    }
                } else if (!player.isShiftKeyDown() && chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                    ChalkUtils.spawnChalkParticle(level, clickLocation.x(), clickLocation.y() + 0.2, clickLocation.z(), this.getDyeColor());
                }
            }
        }
        if (!level.isClientSide()) {
            InteractionResult interactionResult = this.place(new BlockPlaceContext(useOnContext));
            if (block instanceof ChalkDustBlock) {
                ChalkDustBlock chalkDustBlock = (ChalkDustBlock)block;
                if (player != null) {
                    if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ChalkStickItem && !(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ChalkStickItem)) {
                        if (chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                            ChalkUtils.spawnChalkParticle(level, clickLocation.x(), clickLocation.y() + 0.2, clickLocation.z(), this.getDyeColor());
                            level.setBlockAndUpdate(blockPos, ChalkUtils.changeChalkDustState(blockState, player, 1));
                            level.playSound(null, blockPos, SoundEvents.CALCITE_HIT, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.2f + 0.9f);
                            return InteractionResult.SUCCESS;
                        }
                    } else {
                        if (player.isShiftKeyDown()) {
                            itemStack.set(ACDataComponents.CHALK_PATTERN.get(), (Object)ChalkUtils.getChalkPatternFromChalkDust(blockState));
                            return InteractionResult.SUCCESS;
                        }
                        if (chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                            ChalkUtils.spawnChalkParticle(level, clickLocation.x(), clickLocation.y() + 0.2, clickLocation.z(), this.getDyeColor());
                            level.setBlockAndUpdate(blockPos, ChalkUtils.changeChalkDustState(blockState, player, 1));
                            level.playSound(null, blockPos, SoundEvents.CALCITE_HIT, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.2f + 0.9f);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            return interactionResult;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult place(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.getLevel();
        if (!blockPlaceContext.canPlace() || blockPlaceContext.getClickedPos().getY() > level.getMaxBuildHeight()) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = blockPlaceContext.getClickedPos();
        Player player = blockPlaceContext.getPlayer();
        ItemStack itemStack = blockPlaceContext.getItemInHand();
        if (player != null) {
            InteractionHand hand = player.getUsedItemHand();
            BlockState state = ACBlocks.getChalkDust(this.getDyeColor()).getStateForPlacement(blockPlaceContext);
            BlockState clickedState = level.getBlockState(pos);
            if (state != null && !(clickedState.getBlock() instanceof ChalkDustBlock)) {
                RandomSource randomSource = level.getRandom();
                int chalkPattern = (Integer)itemStack.getOrDefault(ACDataComponents.CHALK_PATTERN.get(), (Object)0);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(chalkPattern)));
                level.playSound(null, pos, SoundEvents.CALCITE_HIT, SoundSource.BLOCKS, 0.5f, randomSource.nextFloat() * 0.2f + 0.9f);
                level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)clickedState));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, itemStack);
                }
                clickedState.getBlock().setPlacedBy(level, pos, clickedState, (LivingEntity)player, itemStack);
                if (!player.getAbilities().instabuild && !(clickedState.getBlock() instanceof ChalkDustBlock)) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    } else {
                        itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
                    }
                }
                if (!level.isClientSide()) {
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }
}

