/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.entity;

import com.kekecreations.arts_and_crafts.common.entity.ACBoatAccessor;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACEntityTypes;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ACBoat
extends Boat
implements ACBoatAccessor {
    private static final EntityDataAccessor<Integer> DATA_ID_BOAT_WOOD_TYPE = SynchedEntityData.defineId(ACBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ACBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public ACBoat(Level level, double x, double y, double z) {
        this(ACEntityTypes.BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_BOAT_WOOD_TYPE, (Object)WoodType.OAK.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putString("wood_type", this.getBoatWoodType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("wood_type", 8)) {
            this.entityData.set(DATA_ID_BOAT_WOOD_TYPE, (Object)WoodType.byName(nbt.getString("wood_type")).ordinal());
        }
    }

    public Item getDropItem() {
        return switch (WoodType.byId((Integer)this.entityData.get(DATA_ID_BOAT_WOOD_TYPE)).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Items.OAK_BOAT;
            case 1 -> ACItems.CORK_BOAT.get();
        };
    }

    @Override
    public void setBoatWoodType(WoodType type) {
        this.entityData.set(DATA_ID_BOAT_WOOD_TYPE, (Object)type.ordinal());
    }

    @Override
    public WoodType getBoatWoodType() {
        return WoodType.byId((Integer)this.entityData.get(DATA_ID_BOAT_WOOD_TYPE));
    }

    public static enum WoodType implements StringRepresentable
    {
        OAK(Blocks.OAK_PLANKS, "oak"),
        CORK((Block)ACBlocks.CORK_PLANKS.get(), "cork");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<WoodType> CODEC;
        private static final IntFunction<WoodType> BY_ID;

        private WoodType(Block block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static WoodType byId(int i) {
            return BY_ID.apply(i);
        }

        public static WoodType byName(String string) {
            return (WoodType)CODEC.byName(string, (Enum)OAK);
        }

        static {
            CODEC = StringRepresentable.fromEnum(WoodType::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])WoodType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

