/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.common.entity.DyedDecoratedPotBlockEntity;
import com.kekecreations.arts_and_crafts.core.platform.Services;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DyedDecoratedPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private final DyeColor dyeColor;
    public static final ResourceLocation SHERDS_DYNAMIC_DROP_ID = ResourceLocation.withDefaultNamespace((String)"sherds");
    private static final VoxelShape BOUNDING_BOX = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final DirectionProperty HORIZONTAL_FACING;
    public static final BooleanProperty CRACKED;
    private static final BooleanProperty WATERLOGGED;
    public static final MapCodec<DyedDecoratedPotBlock> CODEC;

    public DyedDecoratedPotBlock(DyeColor colour, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false)));
        this.dyeColor = colour;
    }

    public boolean isEnabled(FeatureFlagSet $$0) {
        return Services.CONFIG.areDyedDecoratedPotsEnabled();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        DyedDecoratedPotBlockEntity customDecoratedPotBlockEntity = new DyedDecoratedPotBlockEntity(blockPos, blockState);
        customDecoratedPotBlockEntity.setDyeColor(this.dyeColor.getId());
        return customDecoratedPotBlockEntity;
    }

    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.getLevel().getFluidState(blockPlaceContext.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity var9 = level.getBlockEntity(blockPos);
        if (var9 instanceof DyedDecoratedPotBlockEntity) {
            DyedDecoratedPotBlockEntity decoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)var9;
            if (level.isClientSide) {
                return ItemInteractionResult.CONSUME;
            }
            ItemStack itemStack2 = decoratedPotBlockEntity.getTheItem();
            if (!itemStack.isEmpty() && (itemStack2.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)itemStack) && itemStack2.getCount() < itemStack2.getMaxStackSize())) {
                float f;
                ItemStack itemStack3;
                decoratedPotBlockEntity.wobble(DyedDecoratedPotBlockEntity.WobbleStyle.POSITIVE);
                player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                ItemStack itemStack4 = itemStack3 = player.isCreative() ? itemStack.copyWithCount(1) : itemStack.split(1);
                if (decoratedPotBlockEntity.isEmpty()) {
                    decoratedPotBlockEntity.setTheItem(itemStack3);
                    f = (float)itemStack3.getCount() / (float)itemStack3.getMaxStackSize();
                } else {
                    itemStack2.grow(1);
                    f = (float)itemStack2.getCount() / (float)itemStack2.getMaxStackSize();
                }
                level.playSound((Player)null, blockPos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.2, (double)blockPos.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedPotBlockEntity.setChanged();
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity var7 = level.getBlockEntity(blockPos);
        if (var7 instanceof DyedDecoratedPotBlockEntity) {
            DyedDecoratedPotBlockEntity decoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)var7;
            level.playSound((Player)null, blockPos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
            decoratedPotBlockEntity.wobble(DyedDecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return BOUNDING_BOX;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING, WATERLOGGED, CRACKED});
    }

    protected void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        Containers.dropContentsOnDestroy((BlockState)blockState, (BlockState)blockState2, (Level)level, (BlockPos)blockPos);
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    protected List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof DyedDecoratedPotBlockEntity) {
            DyedDecoratedPotBlockEntity decoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)blockEntity;
            builder.withDynamicDrop(SHERDS_DYNAMIC_DROP_ID, consumer -> {
                for (Item item : decoratedPotBlockEntity.getDecorations().ordered()) {
                    consumer.accept(item.getDefaultInstance());
                }
            });
        }
        return super.getDrops(blockState, builder);
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        ItemStack itemStack = player.getMainHandItem();
        BlockState blockState2 = blockState;
        if (itemStack.is(ItemTags.BREAKS_DECORATED_POTS) && !EnchantmentHelper.hasTag((ItemStack)itemStack, (TagKey)EnchantmentTags.PREVENTS_DECORATED_POT_SHATTERING)) {
            blockState2 = (BlockState)blockState.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true));
            level.setBlock(blockPos, blockState2, 4);
        }
        return super.playerWillDestroy(level, blockPos, blockState2, player);
    }

    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    protected SoundType getSoundType(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)CRACKED) != false ? SoundType.DECORATED_POT_CRACKED : SoundType.DECORATED_POT;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        PotDecorations potDecorations = (PotDecorations)itemStack.getOrDefault(DataComponents.POT_DECORATIONS, (Object)PotDecorations.EMPTY);
        if (!potDecorations.equals((Object)PotDecorations.EMPTY)) {
            list.add(CommonComponents.EMPTY);
            Stream.of(potDecorations.front(), potDecorations.left(), potDecorations.right(), potDecorations.back()).forEach(optional -> list.add((Component)new ItemStack((ItemLike)optional.orElse(Items.BRICK), 1).getHoverName().plainCopy().withStyle(ChatFormatting.GRAY)));
        }
    }

    protected void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, blockPos) && projectile.mayBreak(level)) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true)), 4);
            level.destroyBlock(blockPos, true, (Entity)projectile);
        }
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        BlockEntity var5 = levelReader.getBlockEntity(blockPos);
        if (var5 instanceof DyedDecoratedPotBlockEntity) {
            DyedDecoratedPotBlockEntity decoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)var5;
            return decoratedPotBlockEntity.getPotAsItem(this.dyeColor);
        }
        return super.getCloneItemStack(levelReader, blockPos, blockState);
    }

    protected boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(blockPos));
    }

    protected BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)HORIZONTAL_FACING)));
    }

    protected BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)HORIZONTAL_FACING)));
    }

    public static Block getBlockByColor(@Nullable DyeColor arg) {
        if (arg == null) {
            return Blocks.DECORATED_POT;
        }
        return switch (arg) {
            default -> Blocks.DECORATED_POT;
            case DyeColor.WHITE -> ACBlocks.getDyedDecoratedPot(DyeColor.WHITE.getId());
            case DyeColor.ORANGE -> ACBlocks.getDyedDecoratedPot(DyeColor.ORANGE.getId());
            case DyeColor.MAGENTA -> ACBlocks.getDyedDecoratedPot(DyeColor.MAGENTA.getId());
            case DyeColor.LIGHT_BLUE -> ACBlocks.getDyedDecoratedPot(DyeColor.LIGHT_BLUE.getId());
            case DyeColor.YELLOW -> ACBlocks.getDyedDecoratedPot(DyeColor.YELLOW.getId());
            case DyeColor.LIME -> ACBlocks.getDyedDecoratedPot(DyeColor.LIME.getId());
            case DyeColor.PINK -> ACBlocks.getDyedDecoratedPot(DyeColor.PINK.getId());
            case DyeColor.GRAY -> ACBlocks.getDyedDecoratedPot(DyeColor.GRAY.getId());
            case DyeColor.LIGHT_GRAY -> ACBlocks.getDyedDecoratedPot(DyeColor.LIGHT_GRAY.getId());
            case DyeColor.CYAN -> ACBlocks.getDyedDecoratedPot(DyeColor.CYAN.getId());
            case DyeColor.PURPLE -> ACBlocks.getDyedDecoratedPot(DyeColor.PURPLE.getId());
            case DyeColor.BLUE -> ACBlocks.getDyedDecoratedPot(DyeColor.BLUE.getId());
            case DyeColor.BROWN -> ACBlocks.getDyedDecoratedPot(DyeColor.BROWN.getId());
            case DyeColor.GREEN -> ACBlocks.getDyedDecoratedPot(DyeColor.GREEN.getId());
            case DyeColor.RED -> ACBlocks.getDyedDecoratedPot(DyeColor.RED.getId());
            case DyeColor.BLACK -> ACBlocks.getDyedDecoratedPot(DyeColor.BLACK.getId());
        };
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)DyeColor.CODEC.fieldOf("dyecolor").forGetter($$0x -> $$0x.dyeColor), (App)DyedDecoratedPotBlock.propertiesCodec()).apply((Applicative)$$0, DyedDecoratedPotBlock::new));
        HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
        CRACKED = BlockStateProperties.CRACKED;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
    }
}

