/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.processor;

import com.yungnickyoung.minecraft.yungsbridges.world.processor.ITemplateFeatureProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class FenceBiomeProcessor
implements ITemplateFeatureProcessor {
    @Override
    public void processTemplate(StructureTemplate template, WorldGenLevel level, RandomSource randomSource, BlockPos cornerPos, BlockPos centerPos, StructurePlaceSettings placementSettings) {
        Holder biome = level.getBiome(cornerPos);
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.OAK_FENCE)) {
            if (randomSource.nextFloat() < 0.75f || level.getBlockState(blockInfo.pos().above()).canOcclude()) {
                BlockState fenceBlock = this.getFenceBlockWithState(this.getFenceBiomeVariant((Holder<Biome>)biome), blockInfo.state());
                if (!level.getBlockState(blockInfo.pos().relative(Direction.NORTH)).canOcclude()) {
                    fenceBlock = (BlockState)fenceBlock.setValue((Property)FenceBlock.NORTH, (Comparable)Boolean.valueOf(false));
                }
                if (!level.getBlockState(blockInfo.pos().relative(Direction.WEST)).canOcclude()) {
                    fenceBlock = (BlockState)fenceBlock.setValue((Property)FenceBlock.WEST, (Comparable)Boolean.valueOf(false));
                }
                level.setBlock(blockInfo.pos(), fenceBlock, 2);
                continue;
            }
            level.setBlock(blockInfo.pos(), Blocks.AIR.defaultBlockState(), 2);
            BlockPos neighborPos = blockInfo.pos().relative(Direction.NORTH);
            if (level.getBlockState(neighborPos).hasProperty((Property)FenceBlock.SOUTH) && ((Boolean)level.getBlockState(neighborPos).getValue((Property)FenceBlock.SOUTH)).booleanValue()) {
                level.setBlock(neighborPos, (BlockState)level.getBlockState(neighborPos).setValue((Property)FenceBlock.SOUTH, (Comparable)Boolean.valueOf(false)), 2);
            }
            if (!level.getBlockState(neighborPos = blockInfo.pos().relative(Direction.WEST)).hasProperty((Property)FenceBlock.EAST) || !((Boolean)level.getBlockState(neighborPos).getValue((Property)FenceBlock.EAST)).booleanValue()) continue;
            level.setBlock(neighborPos, (BlockState)level.getBlockState(neighborPos).setValue((Property)FenceBlock.EAST, (Comparable)Boolean.valueOf(false)), 2);
        }
    }
}

