/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.setup.TbLoot;
import net.silentchaos512.treasurebags.setup.TbRegistries;

public final class SetBagTypeFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetBagTypeFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetBagTypeFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.CODEC.fieldOf("bag_type").forGetter(f -> f.typeId)).apply((Applicative)instance, SetBagTypeFunction::new));
    private final ResourceLocation typeId;

    private SetBagTypeFunction(List<LootItemCondition> conditions, ResourceLocation typeId) {
        super(conditions);
        this.typeId = typeId;
    }

    public static LootItemConditionalFunction.Builder<?> builder(ResourceLocation bagTypeId) {
        return SetBagTypeFunction.simpleBuilder(conditions -> new SetBagTypeFunction((List<LootItemCondition>)conditions, bagTypeId));
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        BagType bagType = (BagType)TbRegistries.BAG_TYPE.get(this.typeId);
        if (bagType != null) {
            return TreasureBagItem.setBagProperties(stack, bagType);
        }
        TreasureBags.LOGGER.error("Unknown bag type: {}", (Object)this.typeId);
        return stack;
    }

    public LootItemFunctionType<SetBagTypeFunction> getType() {
        return TbLoot.SET_BAG_TYPE.get();
    }
}

