/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.setup.TbLoot;
import net.silentchaos512.treasurebags.setup.TbRegistries;

public class SelectBagByRarity
extends LootItemConditionalFunction {
    public static final MapCodec<SelectBagByRarity> CODEC = RecordCodecBuilder.mapCodec(instance -> SelectBagByRarity.commonFields((RecordCodecBuilder.Instance)instance).and((App)Rarity.CODEC.fieldOf("rarity").forGetter(f -> f.rarity)).apply((Applicative)instance, SelectBagByRarity::new));
    private final Rarity rarity;

    public SelectBagByRarity(List<LootItemCondition> conditions, Rarity rarity) {
        super(conditions);
        this.rarity = rarity;
    }

    public static LootItemConditionalFunction.Builder<?> builder(Rarity rarity) {
        return SelectBagByRarity.simpleBuilder(conditions -> new SelectBagByRarity((List<LootItemCondition>)conditions, rarity));
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity == null) {
            return ItemStack.EMPTY;
        }
        List<BagType> list = TbRegistries.BAG_TYPE.stream().filter(type -> type.canDropFromMob(entity) && type.rarity() == this.rarity).toList();
        if (list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        BagType bagType = list.get(TreasureBags.RANDOM.nextInt(list.size()));
        return TreasureBagItem.setBagProperties(stack, bagType);
    }

    public LootItemFunctionType<SelectBagByRarity> getType() {
        return TbLoot.SELECT_BAG_BY_RARITY.get();
    }
}

