/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.setup.EntityGroups;
import org.jetbrains.annotations.NotNull;

public class BagDropLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<BagDropLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> BagDropLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, BagDropLootModifier::new)));

    public BagDropLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        TreasureBags.LOGGER.debug("{}: {}", (Object)context.getQueriedLootTableId(), context.getParamOrNull(LootContextParams.THIS_ENTITY));
        Entity thisEntity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (thisEntity == null) {
            return generatedLoot;
        }
        ObjectArrayList ret = new ObjectArrayList(generatedLoot);
        MinecraftServer server = context.getLevel().getServer();
        HolderGetter lootTableLookup = (HolderGetter)server.reloadableRegistries().lookup().lookup(Registries.LOOT_TABLE).orElseThrow();
        EntityGroups.forEachGroup(thisEntity, (group, entity) -> lootTableLookup.get(group.getLootTable()).ifPresent(lootTable -> ((LootTable)lootTable.value()).getRandomItemsRaw(context, arg_0 -> ((ObjectArrayList)ret).add(arg_0))));
        return ret;
    }
}

