/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.lib;

import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootTable;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.api.IEntityGroup;

public enum StandardEntityGroups implements IEntityGroup
{
    PLAYER(StandardEntityGroups::isPlayer),
    BOSS(StandardEntityGroups::isBoss),
    HOSTILE(StandardEntityGroups::isHostile),
    PEACEFUL(StandardEntityGroups::isPeacefulMob);

    private final ResourceKey<LootTable> lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)TreasureBags.getId("entity_group/" + this.getName()));
    private final Predicate<Entity> predicate;

    private StandardEntityGroups(Predicate<Entity> predicate) {
        this.predicate = predicate;
    }

    @Override
    public ResourceLocation getId() {
        return TreasureBags.getId(this.getName());
    }

    @Override
    public boolean matches(Entity entity) {
        return this.predicate.test(entity);
    }

    @Override
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private static boolean isPlayer(Entity entity) {
        return entity instanceof Player;
    }

    private static boolean isBoss(Entity entity) {
        return entity.isAlive() && !entity.canUsePortal(true);
    }

    private static boolean isHostile(Entity entity) {
        return entity instanceof Enemy;
    }

    private static boolean isPeacefulMob(Entity e) {
        return !StandardEntityGroups.isPlayer(e) && !StandardEntityGroups.isBoss(e) && !StandardEntityGroups.isHostile(e);
    }
}

