/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.lib;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.lib.BagTypeJsonException;
import net.silentchaos512.treasurebags.lib.DataResourceManager;

public final class BagTypeManager
extends DataResourceManager<BagType> {
    public BagTypeManager() {
        super(BagType.CODEC, BagTypeJsonException::new, "bag type", "treasurebags_types", "BagTypeManager", TreasureBags.LOGGER);
    }

    @Nullable
    public BagType typeFromBag(ItemStack stack) {
        if (!(stack.getItem() instanceof TreasureBagItem)) {
            return null;
        }
        return TreasureBagItem.getBagType(stack);
    }

    @Override
    public Collection<Component> getErrorMessages(ServerPlayer player) {
        ArrayList<Component> messages = new ArrayList<Component>(super.getErrorMessages(player));
        int missingLootTables = this.countMissingLootTables(player);
        if (missingLootTables > 0) {
            Object counter = missingLootTables == 1 ? "1 bag type has a missing or invalid loot table" : missingLootTables + " bag types have missing or invalid loot tables";
            messages.add(BagTypeManager.errorMessage((String)counter));
        }
        return messages;
    }

    private int countMissingLootTables(ServerPlayer player) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return 0;
        }
        HolderGetter lootTables = (HolderGetter)server.reloadableRegistries().lookup().lookup(Registries.LOOT_TABLE).orElseThrow();
        return (int)this.stream().filter(bagType -> lootTables.get(bagType.lootTable()).isEmpty()).count();
    }

    private static Component errorMessage(String str) {
        return Component.literal((String)"[Treasure Bags] ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)str).withStyle(ChatFormatting.WHITE));
    }
}

