/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.lib;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.treasurebags.api.IEntityGroup;

public record BagType(String group, Rarity rarity, List<IEntityGroup> dropsFromGroups, int bagColor, int bagOverlayColor, int bagStringColor, Component customName, ResourceKey<LootTable> lootTable, boolean visible) {
    public static final Codec<BagType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(bt -> bt.group), (App)Rarity.CODEC.fieldOf("rarity").forGetter(bt -> bt.rarity), (App)Codec.list(IEntityGroup.CODEC).fieldOf("drops_from_groups").forGetter(bt -> bt.dropsFromGroups), (App)Color.CODEC.fieldOf("bag_color").forGetter(bt -> new Color(bt.bagColor)), (App)Color.CODEC.fieldOf("bag_overlay_color").forGetter(bt -> new Color(bt.bagOverlayColor)), (App)Color.CODEC.fieldOf("bag_string_color").forGetter(bt -> new Color(bt.bagStringColor)), (App)ComponentSerialization.CODEC.fieldOf("display_name").forGetter(bt -> bt.customName), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(bt -> bt.lootTable), (App)Codec.BOOL.fieldOf("visible").forGetter(bt -> bt.visible)).apply((Applicative)instance, BagType::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BagType> STREAM_CODEC = StreamCodec.of(BagType::encode, BagType::decode);

    public BagType(String group, Rarity rarity, List<IEntityGroup> dropsFromGroups, Color bagColor, Color bagOverlayColor, Color bagStringColor, Component customName, ResourceKey<LootTable> lootTable, boolean visible) {
        this(group, rarity, dropsFromGroups, bagColor.getColor() | 0xFF000000, bagOverlayColor.getColor() | 0xFF000000, bagStringColor.getColor() | 0xFF000000, customName, lootTable, visible);
    }

    private static void encode(RegistryFriendlyByteBuf buf, BagType bagType) {
        buf.writeUtf(bagType.group);
        Rarity.STREAM_CODEC.encode((Object)buf, (Object)bagType.rarity);
        IEntityGroup.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buf, bagType.dropsFromGroups);
        buf.writeInt(bagType.bagColor);
        buf.writeInt(bagType.bagOverlayColor);
        buf.writeInt(bagType.bagStringColor);
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)bagType.customName);
        ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE).encode((Object)buf, bagType.lootTable);
        buf.writeBoolean(bagType.visible);
    }

    private static BagType decode(RegistryFriendlyByteBuf buf) {
        return new BagType(buf.readUtf(), (Rarity)Rarity.STREAM_CODEC.decode((Object)buf), (List<IEntityGroup>)((List)IEntityGroup.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buf)), buf.readInt() | 0xFF000000, buf.readInt() | 0xFF000000, buf.readInt() | 0xFF000000, (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf), (ResourceKey<LootTable>)((ResourceKey)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE).decode((Object)buf)), buf.readBoolean());
    }

    public boolean canDropFromMob(Entity entity) {
        for (IEntityGroup group : this.dropsFromGroups) {
            if (!group.matches(entity)) continue;
            return true;
        }
        return false;
    }
}

