/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.silentchaos512.lib.item.LootContainerItem;
import net.silentchaos512.treasurebags.Config;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.setup.TbDataComponents;
import net.silentchaos512.treasurebags.setup.TbRegistries;

public class TreasureBagItem
extends LootContainerItem {
    public TreasureBagItem(Item.Properties properties) {
        super(TreasureBags.getId("default_bag"), true, properties);
    }

    public ItemStack stackOfType(BagType type) {
        return this.stackOfType(type, 1);
    }

    public ItemStack stackOfType(BagType type, int count) {
        ItemStack result = new ItemStack((ItemLike)this, count);
        return TreasureBagItem.setBagProperties(result, type);
    }

    public ItemStack stackOfType(ResourceLocation typeName) {
        ItemStack result = new ItemStack((ItemLike)this);
        return TreasureBagItem.setBagType(result, typeName);
    }

    @Nullable
    public static BagType getBagType(ItemStack stack) {
        ResourceLocation id = (ResourceLocation)stack.get(TbDataComponents.BAG_TYPE);
        return id != null ? (BagType)TbRegistries.BAG_TYPE.get(id) : null;
    }

    public static ItemStack setBagType(ItemStack stack, ResourceLocation bagTypeId) {
        stack.set(TbDataComponents.BAG_TYPE, (Object)bagTypeId);
        return stack;
    }

    public static ItemStack setBagProperties(ItemStack stack, BagType type) {
        TreasureBagItem.setBagType(stack, TbRegistries.BAG_TYPE.getKey(type));
        TreasureBagItem.setLootTable((ItemStack)stack, type.lootTable());
        stack.set(DataComponents.RARITY, (Object)type.rarity());
        return stack;
    }

    @Nonnull
    protected ResourceKey<LootTable> getLootTable(ItemStack stack) {
        BagType type = TreasureBagItem.getBagType(stack);
        if (type == null) {
            return super.getLootTable(stack);
        }
        return type.lootTable();
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        BagType type = TreasureBagItem.getBagType(stack);
        if (type != null) {
            return type.customName();
        }
        return super.getName(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(ItemStack stack, int tintIndex) {
        BagType bagType = TreasureBagItem.getBagType(stack);
        if (bagType != null) {
            if (tintIndex == 0) {
                return bagType.bagColor();
            }
            if (tintIndex == 1) {
                return bagType.bagOverlayColor();
            }
            if (tintIndex == 2) {
                return bagType.bagStringColor();
            }
        }
        return 0xFFFFFF;
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, TooltipFlag flag) {
        BagType type = TreasureBagItem.getBagType(stack);
        ResourceLocation typeId = type != null ? TbRegistries.BAG_TYPE.getKey(type) : null;
        String typeName = typeId != null ? typeId.toString() : "null";
        this.appendInfoPair(tooltip, flag, true, "type", typeName);
        if (type != null) {
            this.appendInfoPair(tooltip, flag, true, "group", type.group());
            this.appendInfoPair(tooltip, flag, true, "lootTable", type.lootTable().location().toString());
        } else {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".invalidType")).withStyle(ChatFormatting.RED));
        }
        this.appendInfoPair(tooltip, flag, false, "packName", typeId != null ? typeId.getNamespace() : "null");
    }

    private void appendInfoPair(List<Component> tooltip, TooltipFlag flag, boolean advancedOnly, String key, String value) {
        if (flag.isAdvanced() || !advancedOnly) {
            MutableComponent valueText = Component.literal((String)value).withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + "." + key), (Object[])new Object[]{valueText}).withStyle(ChatFormatting.AQUA));
        }
    }

    public List<ItemStack> getSubItems() {
        NonNullList items = NonNullList.create();
        ArrayList list = new ArrayList(TbRegistries.BAG_TYPE.stream().toList());
        list.sort(Comparator.comparing(bagType -> TbRegistries.BAG_TYPE.getKey(bagType).toString()));
        for (BagType type : list) {
            if (!type.visible()) continue;
            items.add((Object)this.stackOfType(type));
        }
        return items;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack heldItem = playerIn.getItemInHand(handIn);
        if (!(playerIn instanceof ServerPlayer)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
        }
        ServerPlayer playerMP = (ServerPlayer)playerIn;
        boolean openWholeStack = playerMP.isCrouching();
        Collection<ItemStack> lootDrops = this.getDropsFromStack(heldItem, playerMP, openWholeStack);
        if (lootDrops.isEmpty()) {
            TreasureBags.LOGGER.warn("No drops from bag, is the loot table valid? {}, table={}", (Object)heldItem, this.getLootTable(heldItem));
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldItem);
        }
        lootDrops.forEach(stack -> {
            this.giveOrDropItem(playerIn, stack.copy());
            TreasureBagItem.listItemReceivedInChat(playerMP, stack);
        });
        playerMP.level().playSound(null, playerMP.getX(), playerMP.getY(), playerMP.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((playerMP.getRandom().nextFloat() - playerMP.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        heldItem.shrink(openWholeStack ? heldItem.getCount() : 1);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
    }

    private void giveOrDropItem(Player playerIn, ItemStack copy) {
        if (((Boolean)Config.Common.alwaysSpawnItems.get()).booleanValue() || !playerIn.getInventory().add(copy)) {
            ItemEntity entityItem = new ItemEntity(playerIn.level(), playerIn.getX(), playerIn.getY(0.5), playerIn.getZ(), copy);
            entityItem.setNoPickUpDelay();
            entityItem.setThrower((Entity)playerIn);
            playerIn.level().addFreshEntity((Entity)entityItem);
        }
    }

    private Collection<ItemStack> getDropsFromStack(ItemStack stack, ServerPlayer player, boolean wholeStack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int openCount = wholeStack ? stack.getCount() : 1;
        for (int i = 0; i < openCount; ++i) {
            this.getLootDrops(stack, player).forEach(s -> TreasureBagItem.mergeItem(list, s));
        }
        return list;
    }

    private static void mergeItem(Collection<ItemStack> list, ItemStack stack) {
        for (ItemStack itemStack : list) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack)) continue;
            int space = itemStack.getMaxStackSize() - itemStack.getCount();
            int toMerge = Math.min(space, stack.getCount());
            itemStack.grow(toMerge);
            stack.shrink(toMerge);
            if (!stack.isEmpty()) continue;
            return;
        }
        if (!stack.isEmpty()) {
            list.add(stack);
        }
    }

    private static void listItemReceivedInChat(ServerPlayer playerMP, ItemStack stack) {
        MutableComponent itemReceivedText = Component.translatable((String)"item.silentlib.lootContainer.itemReceived", (Object[])new Object[]{stack.getCount(), stack.getHoverName()});
        playerMP.sendSystemMessage((Component)itemReceivedText);
    }
}

